/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.JoinExpression;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryFlag;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.Param;
import com.querydsl.core.types.dsl.StringPath;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DefaultQueryMetadataTest {
    private final QueryMetadata metadata = new DefaultQueryMetadata();
    private final StringPath str = Expressions.stringPath((String)"str");
    private final StringPath str2 = Expressions.stringPath((String)"str2");

    public DefaultQueryMetadataTest() {
        this.metadata.setValidate(true);
    }

    @Test
    public void addWhere_with_null() {
        this.metadata.addWhere(null);
    }

    @Test
    public void addWhere_with_booleanBuilder() {
        this.metadata.addWhere((Predicate)new BooleanBuilder());
    }

    @Test
    public void addHaving_with_null() {
        this.metadata.addHaving(null);
    }

    @Test
    public void addHaving_with_booleanBuilder() {
        this.metadata.addHaving((Predicate)new BooleanBuilder());
    }

    @Test(expected=IllegalArgumentException.class)
    public void validation() {
        this.metadata.addWhere((Predicate)this.str.isNull());
    }

    @Test
    public void validation_no_error_for_groupBy() {
        this.metadata.addGroupBy((Expression)this.str);
    }

    @Test
    public void validation_no_error_for_having() {
        this.metadata.addHaving((Predicate)this.str.isNull());
    }

    @Test
    public void getGroupBy() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        this.metadata.addGroupBy((Expression)this.str);
        Assertions.assertThat((List)this.metadata.getGroupBy()).isEqualTo(Collections.singletonList(this.str));
    }

    @Test
    public void getHaving() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        this.metadata.addHaving((Predicate)this.str.isNotNull());
        Assertions.assertThat((Object)this.metadata.getHaving()).isEqualTo((Object)this.str.isNotNull());
    }

    @Test
    public void getJoins() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        Assertions.assertThat((List)this.metadata.getJoins()).isEqualTo(Collections.singletonList(new JoinExpression(JoinType.DEFAULT, (Expression)this.str)));
    }

    @Test
    public void getJoins2() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        Assertions.assertThat((List)this.metadata.getJoins()).isEqualTo(Collections.singletonList(new JoinExpression(JoinType.DEFAULT, (Expression)this.str)));
    }

    @Test
    public void getJoins3() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        Assertions.assertThat((List)this.metadata.getJoins()).isEqualTo(Collections.singletonList(new JoinExpression(JoinType.DEFAULT, (Expression)this.str)));
        this.metadata.addJoinCondition((Predicate)this.str.isNull());
        Assertions.assertThat((List)this.metadata.getJoins()).isEqualTo(Collections.singletonList(new JoinExpression(JoinType.DEFAULT, (Expression)this.str, (Predicate)this.str.isNull(), Collections.emptySet())));
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str2);
        Assertions.assertThat((List)this.metadata.getJoins()).isEqualTo(Arrays.asList(new JoinExpression(JoinType.DEFAULT, (Expression)this.str, (Predicate)this.str.isNull(), Collections.emptySet()), new JoinExpression(JoinType.DEFAULT, (Expression)this.str2)));
    }

    @Test
    public void getModifiers() {
        QueryModifiers modifiers = new QueryModifiers(Long.valueOf(1L), Long.valueOf(2L));
        this.metadata.setModifiers(modifiers);
        Assertions.assertThat((Object)this.metadata.getModifiers()).isEqualTo((Object)modifiers);
    }

    @Test
    public void setLimit() {
        QueryModifiers modifiers = new QueryModifiers(Long.valueOf(1L), Long.valueOf(2L));
        this.metadata.setModifiers(modifiers);
        this.metadata.setLimit(Long.valueOf(3L));
        Assertions.assertThat((Long)this.metadata.getModifiers().getLimit()).isEqualTo((Object)3L);
        Assertions.assertThat((Long)this.metadata.getModifiers().getOffset()).isEqualTo((Object)2L);
    }

    @Test
    public void setOffset() {
        QueryModifiers modifiers = new QueryModifiers(Long.valueOf(1L), Long.valueOf(1L));
        this.metadata.setModifiers(modifiers);
        this.metadata.setOffset(Long.valueOf(2L));
        Assertions.assertThat((Long)this.metadata.getModifiers().getLimit()).isEqualTo((Object)1L);
        Assertions.assertThat((Long)this.metadata.getModifiers().getOffset()).isEqualTo((Object)2L);
    }

    @Test
    public void getOrderBy() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        this.metadata.addOrderBy(this.str.asc());
        this.metadata.addOrderBy(this.str.desc());
        Assertions.assertThat((List)this.metadata.getOrderBy()).isEqualTo(Arrays.asList(this.str.asc(), this.str.desc()));
    }

    @Test
    public void getProjection() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        this.metadata.setProjection((Expression)this.str.append("abc"));
        Assertions.assertThat((Object)this.metadata.getProjection()).isEqualTo((Object)this.str.append("abc"));
    }

    @Test
    public void getWhere() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        this.metadata.addWhere((Predicate)this.str.eq((Object)"b"));
        this.metadata.addWhere((Predicate)this.str.isNotEmpty());
        Assertions.assertThat((Object)this.metadata.getWhere()).isEqualTo((Object)this.str.eq((Object)"b").and((Predicate)this.str.isNotEmpty()));
    }

    @Test
    public void isDistinct() {
        Assertions.assertThat((boolean)this.metadata.isDistinct()).isFalse();
        this.metadata.setDistinct(true);
        Assertions.assertThat((boolean)this.metadata.isDistinct()).isTrue();
    }

    @Test
    public void isUnique() {
        Assertions.assertThat((boolean)this.metadata.isUnique()).isFalse();
        this.metadata.setUnique(true);
        Assertions.assertThat((boolean)this.metadata.isUnique()).isTrue();
    }

    @Test
    public void joinShouldBeCommitted() {
        DefaultQueryMetadata md = new DefaultQueryMetadata();
        md.addJoin(JoinType.DEFAULT, (Expression)this.str);
        DefaultQueryMetadata emptyMetadata = new DefaultQueryMetadata();
        Assertions.assertThat((boolean)md.equals((Object)emptyMetadata)).isFalse();
    }

    @Test
    public void clone_() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        this.metadata.addGroupBy((Expression)this.str);
        this.metadata.addHaving((Predicate)this.str.isNotNull());
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str2);
        QueryModifiers modifiers = new QueryModifiers(Long.valueOf(1L), Long.valueOf(2L));
        this.metadata.setModifiers(modifiers);
        this.metadata.addOrderBy(this.str.asc());
        this.metadata.setProjection((Expression)this.str.append("abc"));
        this.metadata.addWhere((Predicate)this.str.eq((Object)"b"));
        this.metadata.addWhere((Predicate)this.str.isNotEmpty());
        QueryMetadata clone = this.metadata.clone();
        Assertions.assertThat((List)clone.getGroupBy()).isEqualTo((Object)this.metadata.getGroupBy());
        Assertions.assertThat((Object)clone.getHaving()).isEqualTo((Object)this.metadata.getHaving());
        Assertions.assertThat((List)clone.getJoins()).isEqualTo((Object)this.metadata.getJoins());
        Assertions.assertThat((Object)clone.getModifiers()).isEqualTo((Object)this.metadata.getModifiers());
        Assertions.assertThat((List)clone.getOrderBy()).isEqualTo((Object)this.metadata.getOrderBy());
        Assertions.assertThat((Object)clone.getProjection()).isEqualTo((Object)this.metadata.getProjection());
        Assertions.assertThat((Object)clone.getWhere()).isEqualTo((Object)this.metadata.getWhere());
    }

    @Test
    public void setParam() {
        this.metadata.setParam((ParamExpression)new Param(String.class, "str"), (Object)ConstantImpl.create((Object)"X"));
        Assertions.assertThat((Map)this.metadata.getParams()).hasSize(1);
        Assertions.assertThat((boolean)this.metadata.getParams().get(new Param(String.class, "str")).equals(ConstantImpl.create((Object)"X"))).isTrue();
    }

    @Test
    public void addFlag() {
        QueryFlag flag = new QueryFlag(QueryFlag.Position.START, "X");
        this.metadata.addFlag(flag);
        Assertions.assertThat((boolean)this.metadata.hasFlag(flag)).isTrue();
    }

    @Test
    public void equals() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        this.metadata.addGroupBy((Expression)this.str);
        this.metadata.addHaving((Predicate)this.str.isNotNull());
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str2);
        QueryModifiers modifiers = new QueryModifiers(Long.valueOf(1L), Long.valueOf(2L));
        this.metadata.setModifiers(modifiers);
        this.metadata.addOrderBy(this.str.asc());
        this.metadata.setProjection((Expression)this.str.append("abc"));
        this.metadata.addWhere((Predicate)this.str.eq((Object)"b"));
        this.metadata.addWhere((Predicate)this.str.isNotEmpty());
        DefaultQueryMetadata metadata2 = new DefaultQueryMetadata();
        Assertions.assertThat((boolean)this.metadata.equals((Object)metadata2)).isFalse();
        metadata2.addJoin(JoinType.DEFAULT, (Expression)this.str);
        Assertions.assertThat((boolean)this.metadata.equals((Object)metadata2)).isFalse();
        metadata2.addGroupBy((Expression)this.str);
        Assertions.assertThat((boolean)this.metadata.equals((Object)metadata2)).isFalse();
        metadata2.addHaving((Predicate)this.str.isNotNull());
        Assertions.assertThat((boolean)this.metadata.equals((Object)metadata2)).isFalse();
        metadata2.addJoin(JoinType.DEFAULT, (Expression)this.str2);
        Assertions.assertThat((boolean)this.metadata.equals((Object)metadata2)).isFalse();
        metadata2.setModifiers(modifiers);
        Assertions.assertThat((boolean)this.metadata.equals((Object)metadata2)).isFalse();
        metadata2.addOrderBy(this.str.asc());
        Assertions.assertThat((boolean)this.metadata.equals((Object)metadata2)).isFalse();
        metadata2.setProjection((Expression)this.str.append("abc"));
        Assertions.assertThat((boolean)this.metadata.equals((Object)metadata2)).isFalse();
        metadata2.addWhere((Predicate)this.str.eq((Object)"b"));
        metadata2.addWhere((Predicate)this.str.isNotEmpty());
        Assertions.assertThat((boolean)this.metadata.equals((Object)metadata2)).isTrue();
    }

    @Test
    public void hashCode_() {
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str);
        this.metadata.addGroupBy((Expression)this.str);
        this.metadata.addHaving((Predicate)this.str.isNotNull());
        this.metadata.addJoin(JoinType.DEFAULT, (Expression)this.str2);
        QueryModifiers modifiers = new QueryModifiers(Long.valueOf(1L), Long.valueOf(2L));
        this.metadata.setModifiers(modifiers);
        this.metadata.addOrderBy(this.str.asc());
        this.metadata.setProjection((Expression)this.str.append("abc"));
        this.metadata.addWhere((Predicate)this.str.eq((Object)"b"));
        this.metadata.addWhere((Predicate)this.str.isNotEmpty());
        this.metadata.hashCode();
    }

    @Test
    public void hashCode_empty_metadata() {
        this.metadata.hashCode();
    }
}

