/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.ProjectionsFactory;
import com.querydsl.core.QuerydslModule;
import com.querydsl.core.Target;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MapExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.ArrayExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Coalesce;
import com.querydsl.core.types.dsl.CollectionExpressionBase;
import com.querydsl.core.types.dsl.ComparableExpression;
import com.querydsl.core.types.dsl.DateExpression;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.ListExpression;
import com.querydsl.core.types.dsl.ListPath;
import com.querydsl.core.types.dsl.MapExpressionBase;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.TemporalExpression;
import com.querydsl.core.types.dsl.TimeExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class FilterFactory {
    private final ProjectionsFactory projections;
    private final QuerydslModule module;
    private final Target target;

    public FilterFactory(ProjectionsFactory projections, QuerydslModule module, Target target) {
        this.projections = projections;
        this.module = module;
        this.target = target;
    }

    public Collection<Predicate> booleanFilters(BooleanExpression expr, BooleanExpression other) {
        HashSet<BooleanExpression> rv = new HashSet<BooleanExpression>();
        rv.add(expr.and((Predicate)other));
        rv.add(expr.or((Predicate)other));
        rv.add(expr.not().and((Predicate)other.not()));
        rv.add(expr.not());
        rv.add(other.not());
        return Collections.unmodifiableSet(rv);
    }

    public <A> Collection<Predicate> collection(CollectionExpressionBase<?, A> expr, CollectionExpression<?, A> other, A knownElement) {
        HashSet<BooleanExpression> rv = new HashSet<BooleanExpression>();
        rv.add(expr.contains(knownElement));
        rv.add(expr.isEmpty());
        rv.add(expr.isNotEmpty());
        if (!this.module.equals((Object)QuerydslModule.RDFBEAN)) {
            rv.add(expr.size().gt((Number)0));
        }
        return Collections.unmodifiableSet(rv);
    }

    public <A> Collection<Predicate> array(ArrayExpression<A[], A> expr, ArrayExpression<A[], A> other, A knownElement) {
        HashSet<BooleanExpression> rv = new HashSet<BooleanExpression>();
        if (!this.module.equals((Object)QuerydslModule.RDFBEAN)) {
            rv.add(expr.size().gt((Number)0));
        }
        rv.add(expr.get(0).eq(knownElement));
        return Collections.unmodifiableSet(rv);
    }

    private <A extends Comparable<A>> Collection<Predicate> comparable(ComparableExpression<A> expr, ComparableExpression<A> other, A knownValue) {
        ArrayList<BooleanExpression> rv = new ArrayList<BooleanExpression>(this.exprFilters((SimpleExpression<A>)expr, (SimpleExpression<A>)other, knownValue));
        rv.add(expr.gt(other));
        rv.add(expr.gt(knownValue));
        rv.add(expr.goe(other));
        rv.add(expr.goe(knownValue));
        rv.add(expr.lt(other));
        rv.add(expr.lt(knownValue));
        rv.add(expr.loe(other));
        rv.add(expr.loe(knownValue));
        return Collections.unmodifiableList(rv);
    }

    private <A extends Comparable<A>> Collection<Predicate> dateOrTime(TemporalExpression<A> expr, TemporalExpression<A> other, A knownValue) {
        ArrayList<BooleanExpression> rv = new ArrayList<BooleanExpression>();
        rv.add(expr.after(other));
        rv.add(expr.after(knownValue));
        rv.add(expr.before(other));
        rv.add(expr.before(knownValue));
        return Collections.unmodifiableList(rv);
    }

    public <A extends Comparable> Collection<Predicate> date(DateExpression<A> expr, DateExpression<A> other, A knownValue) {
        ArrayList<Object> rv = new ArrayList<Object>();
        rv.addAll(this.comparable((ComparableExpression<A>)expr, (ComparableExpression<A>)other, knownValue));
        rv.addAll(this.dateOrTime((TemporalExpression<A>)expr, (TemporalExpression<A>)other, knownValue));
        rv.add(expr.dayOfMonth().eq((Expression)other.dayOfMonth()));
        rv.add(expr.month().eq((Expression)other.month()));
        rv.add(expr.year().eq((Expression)other.year()));
        rv.add(expr.yearMonth().eq((Expression)other.yearMonth()));
        if ((this.module.equals((Object)QuerydslModule.SQL) || this.module.equals((Object)QuerydslModule.COLLECTIONS)) && this.target != Target.DERBY) {
            rv.add(expr.yearWeek().eq((Expression)other.yearWeek()));
        }
        return Collections.unmodifiableList(rv);
    }

    public <A extends Comparable> Collection<Predicate> dateTime(DateTimeExpression<A> expr, DateTimeExpression<A> other, A knownValue) {
        ArrayList<Object> rv = new ArrayList<Object>();
        rv.addAll(this.comparable((ComparableExpression<A>)expr, (ComparableExpression<A>)other, knownValue));
        rv.addAll(this.dateOrTime((TemporalExpression<A>)expr, (TemporalExpression<A>)other, knownValue));
        rv.add(expr.dayOfMonth().eq((Object)1));
        rv.add(expr.dayOfMonth().eq((Expression)other.dayOfMonth()));
        rv.add(expr.month().eq((Object)1));
        rv.add(expr.month().eq((Expression)other.month()));
        rv.add(expr.year().eq((Object)2000));
        rv.add(expr.year().eq((Expression)other.year()));
        rv.add(expr.yearMonth().eq((Expression)other.yearMonth()));
        if ((this.module.equals((Object)QuerydslModule.SQL) || this.module.equals((Object)QuerydslModule.COLLECTIONS)) && this.target != Target.DERBY) {
            rv.add(expr.yearWeek().eq((Expression)other.yearWeek()));
        }
        rv.add(expr.hour().eq((Object)1));
        rv.add(expr.hour().eq((Expression)other.hour()));
        rv.add(expr.minute().eq((Object)1));
        rv.add(expr.minute().eq((Expression)other.minute()));
        rv.add(expr.second().eq((Object)Float.valueOf(1.0f)));
        rv.add(expr.second().eq((Expression)other.second()));
        return Collections.unmodifiableList(rv);
    }

    private <A> Collection<BooleanExpression> exprFilters(SimpleExpression<A> expr, SimpleExpression<A> other, A knownValue) {
        HashSet<BooleanExpression> rv = new HashSet<BooleanExpression>();
        rv.add(expr.eq(other));
        rv.add(expr.eq(knownValue));
        rv.add(expr.ne(other));
        rv.add(expr.ne(knownValue));
        return Collections.unmodifiableSet(rv);
    }

    public <A, Q extends SimpleExpression<A>> Collection<Predicate> list(ListPath<A, Q> expr, ListExpression<A, Q> other, A knownElement) {
        ArrayList<Predicate> rv = new ArrayList<Predicate>(this.collection((CollectionExpressionBase<?, A>)expr, (CollectionExpression<?, A>)other, knownElement));
        rv.add((Predicate)expr.get(0).eq(knownElement));
        return Collections.unmodifiableList(rv);
    }

    public <K, V> Collection<Predicate> map(MapExpressionBase<K, V, ?> expr, MapExpression<K, V> other, K knownKey, V knownValue) {
        HashSet<BooleanExpression> rv = new HashSet<BooleanExpression>();
        rv.add(expr.containsKey(knownKey));
        rv.add(expr.containsValue(knownValue));
        rv.add(expr.get(knownKey).eq(knownValue));
        rv.add(expr.get(knownKey).ne(knownValue));
        rv.add(expr.isEmpty());
        rv.add(expr.isNotEmpty());
        if (!this.module.equals((Object)QuerydslModule.RDFBEAN)) {
            rv.add(expr.size().gt((Number)0));
        }
        return Collections.unmodifiableSet(rv);
    }

    public <A extends Number> Collection<Predicate> numeric(NumberExpression<A> expr, NumberExpression<A> other, A knownValue) {
        ArrayList<BooleanExpression> rv = new ArrayList<BooleanExpression>();
        for (NumberExpression<?> num : this.projections.numeric(expr, other, knownValue, true)) {
            rv.add(num.lt(expr));
        }
        rv.add(expr.ne(other));
        rv.add(expr.ne(knownValue));
        rv.add(expr.goe(other));
        rv.add(expr.goe(knownValue));
        rv.add(expr.gt(other));
        rv.add(expr.gt(knownValue));
        rv.add(expr.loe(other));
        rv.add(expr.loe(knownValue));
        rv.add(expr.lt(other));
        rv.add(expr.lt(knownValue));
        rv.add(expr.in(new Number[]{1, 2, 3}));
        rv.add(expr.in(new Number[]{1L, 2L, 3L}));
        if (expr.getType().equals(Integer.class)) {
            NumberExpression<A> eint = expr;
            rv.add(eint.between((Number)1, (Number)2));
            rv.add(eint.notBetween((Number)1, (Number)2));
            rv.add(eint.mod((Number)5).eq((Object)0));
        } else if (expr.getType().equals(Double.class)) {
            NumberExpression<A> edouble = expr;
            rv.add(edouble.between((Number)1.0, (Number)2.0));
            rv.add(edouble.notBetween((Number)1.0, (Number)2.0));
        } else if (expr.getType().equals(Long.class)) {
            NumberExpression<A> elong = expr;
            rv.add(elong.mod((Number)5L).eq((Object)0L));
        }
        return Collections.unmodifiableList(rv);
    }

    public <A> Collection<Predicate> pathFilters(SimpleExpression<A> expr, SimpleExpression<A> other, A knownValue) {
        return Arrays.asList(expr.isNull(), expr.isNotNull());
    }

    public Collection<Predicate> string(StringExpression expr, StringExpression other, String knownValue) {
        ArrayList<Object> rv = new ArrayList<Object>();
        if (expr instanceof Path && other instanceof Path) {
            rv.addAll(this.pathFilters((SimpleExpression)expr, (SimpleExpression)other, (Object)knownValue));
        }
        rv.addAll(this.comparable((ComparableExpression)expr, (ComparableExpression)other, (Comparable)((Object)knownValue)));
        for (SimpleExpression<String> eq : this.projections.string(expr, other, knownValue)) {
            rv.add(eq.eq((Expression)other));
        }
        rv.add(expr.between((Comparable)((Object)"A"), (Comparable)((Object)"Z")));
        rv.add(expr.charAt(0).eq((Object)Character.valueOf(knownValue.charAt(0))));
        rv.add(expr.notBetween((Comparable)((Object)"A"), (Comparable)((Object)"Z")));
        rv.add(expr.contains((Expression)other));
        rv.add(expr.contains(knownValue.substring(0, 1)));
        rv.add(expr.contains(knownValue.substring(1, 2)));
        rv.add(expr.containsIgnoreCase((Expression)other));
        rv.add(expr.containsIgnoreCase(knownValue.substring(0, 1)));
        rv.add(expr.containsIgnoreCase(knownValue.substring(1, 2)));
        rv.add(expr.endsWith((Expression)other));
        rv.add(expr.endsWith(knownValue.substring(1)));
        rv.add(expr.endsWith(knownValue.substring(2)));
        rv.add(expr.equalsIgnoreCase((Expression)other));
        rv.add(expr.equalsIgnoreCase(knownValue));
        rv.add(expr.in(Collections.singletonList(knownValue)));
        rv.add(expr.indexOf((Expression)other).gt((Number)0));
        rv.add(expr.indexOf("X", 1).gt((Number)0));
        rv.add(expr.indexOf(knownValue).gt((Number)0));
        rv.add(expr.locate((Expression)other).gt((Number)1));
        if (!this.target.equals((Object)Target.FIREBIRD)) {
            rv.add(expr.locate("X", 2).gt((Number)1));
        }
        rv.add(expr.locate(knownValue).gt((Number)1));
        rv.add(expr.in((Object[])new String[]{"A", "B", "C"}));
        rv.add(expr.isEmpty());
        rv.add(expr.isNotEmpty());
        rv.add(expr.length().gt((Number)0));
        rv.add(expr.like(knownValue.substring(0, 1) + "%"));
        rv.add(expr.like("%" + knownValue.substring(1)));
        rv.add(expr.like("%" + knownValue.substring(1, 2) + "%"));
        rv.add(expr.like(knownValue.substring(0, 1) + "%", '!'));
        rv.add(expr.like("%" + knownValue.substring(1), '!'));
        rv.add(expr.like("%" + knownValue.substring(1, 2) + "%", '!'));
        rv.add(expr.likeIgnoreCase(knownValue.substring(0, 1) + "%"));
        rv.add(expr.likeIgnoreCase("%" + knownValue.substring(1)));
        rv.add(expr.likeIgnoreCase("%" + knownValue.substring(1, 2) + "%"));
        rv.add(expr.likeIgnoreCase(knownValue.substring(0, 1) + "%", '!'));
        rv.add(expr.likeIgnoreCase("%" + knownValue.substring(1), '!'));
        rv.add(expr.likeIgnoreCase("%" + knownValue.substring(1, 2) + "%", '!'));
        rv.add(expr.notLike(knownValue.substring(0, 1) + "%"));
        rv.add(expr.notLike("%" + knownValue.substring(1)));
        rv.add(expr.notLike("%" + knownValue.substring(1, 2) + "%"));
        if (!(this.target.equals((Object)Target.DERBY) || this.target.equals((Object)Target.DB2) || this.target.equals((Object)Target.FIREBIRD) || this.target.equals((Object)Target.HSQLDB) || this.target.equals((Object)Target.H2) || this.target.equals((Object)Target.SQLITE) || this.target.equals((Object)Target.SQLSERVER))) {
            rv.add(expr.matches(knownValue.substring(0, 1) + ".*"));
            rv.add(expr.matches(".*" + knownValue.substring(1)));
            rv.add(expr.matches(".*" + knownValue.substring(1, 2) + ".*"));
        }
        rv.add(expr.notIn((Object[])new String[]{"A", "B", "C"}));
        rv.add(expr.notBetween((Comparable)((Object)"A"), (Comparable)((Object)"Z")));
        rv.add(expr.notBetween((Expression)other, (Expression)other));
        if (!this.target.equals((Object)Target.DERBY) && !this.module.equals((Object)QuerydslModule.JDO)) {
            rv.add(new Coalesce(String.class, new Expression[]{expr, other}).getValue().eq((Object)"xxx"));
        }
        return Collections.unmodifiableList(rv);
    }

    public <A extends Comparable> Collection<Predicate> time(TimeExpression<A> expr, TimeExpression<A> other, A knownValue) {
        ArrayList<Object> rv = new ArrayList<Object>();
        rv.addAll(this.comparable((ComparableExpression<A>)expr, (ComparableExpression<A>)other, knownValue));
        rv.addAll(this.dateOrTime((TemporalExpression<A>)expr, (TemporalExpression<A>)other, knownValue));
        rv.add(expr.hour().eq((Expression)other.hour()));
        rv.add(expr.minute().eq((Expression)other.minute()));
        rv.add(expr.second().eq((Expression)other.second()));
        return Collections.unmodifiableList(rv);
    }
}

