/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.Fetchable;
import com.querydsl.core.FetchableQuery;
import com.querydsl.core.FilterFactory;
import com.querydsl.core.MatchingFiltersFactory;
import com.querydsl.core.ProjectionsFactory;
import com.querydsl.core.QueryException;
import com.querydsl.core.QuerydslModule;
import com.querydsl.core.Target;
import com.querydsl.core.support.QueryBase;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MapExpression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.ArrayExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.CollectionExpressionBase;
import com.querydsl.core.types.dsl.DateExpression;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.ListExpression;
import com.querydsl.core.types.dsl.ListPath;
import com.querydsl.core.types.dsl.MapExpressionBase;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.TimeExpression;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;

public abstract class QueryExecution {
    private final List<String> errors = new ArrayList<String>();
    private final List<String> failures = new ArrayList<String>();
    private final MatchingFiltersFactory matchers;
    private final ProjectionsFactory projections;
    private final FilterFactory filters;
    private boolean runFilters = true;
    private boolean runProjections = true;
    private boolean counts = true;
    private int total;

    public QueryExecution(QuerydslModule module, Target target) {
        this.projections = new ProjectionsFactory(module, target);
        this.filters = new FilterFactory(this.projections, module, target);
        this.matchers = new MatchingFiltersFactory(module, target);
    }

    public QueryExecution(ProjectionsFactory p, FilterFactory f, MatchingFiltersFactory m) {
        this.projections = p;
        this.filters = f;
        this.matchers = m;
    }

    public void reset() {
        this.errors.clear();
        this.failures.clear();
        this.total = 0;
    }

    private void runProjectionQueries(Collection<? extends Expression<?>> projections) {
        if (this.runProjections) {
            for (Expression<?> pr : projections) {
                ++this.total;
                try {
                    this.runProjection(pr);
                    this.runProjectionDistinct(pr);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    t = this.addError(pr, t);
                }
            }
        }
    }

    private Throwable addError(Expression<?> expr, Throwable throwable) {
        StringBuilder error = new StringBuilder();
        error.append(expr).append(" failed : \n");
        error.append(" ").append(throwable.getClass().getName()).append(" : ").append(throwable.getMessage()).append("\n");
        if (throwable.getCause() != null) {
            throwable = throwable.getCause();
            error.append(" ").append(throwable.getClass().getName()).append(" : ").append(throwable.getMessage()).append("\n");
        }
        this.errors.add(error.toString());
        return throwable;
    }

    private void runFilterQueries(Collection<Predicate> filters, boolean matching) {
        if (this.runFilters) {
            for (Predicate f : filters) {
                ++this.total;
                try {
                    int results = this.runFilter(f);
                    this.runFilterDistinct(f);
                    if (this.counts) {
                        this.runCount(f);
                        this.runCountDistinct(f);
                    }
                    if (!matching || results != 0) continue;
                    this.failures.add(String.valueOf(f) + " failed");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    t = this.addError((Expression<?>)f, t);
                }
            }
        }
    }

    protected abstract Fetchable<?> createQuery();

    protected abstract Fetchable<?> createQuery(Predicate var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long runCount(Predicate f) {
        Fetchable<?> p = this.createQuery(f);
        try {
            long l = p.fetchCount();
            return l;
        }
        finally {
            this.close(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long runCountDistinct(Predicate f) {
        Fetchable<?> p = this.createQuery(f);
        try {
            ((QueryBase)p).distinct();
            long l = p.fetchCount();
            return l;
        }
        finally {
            this.close(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runFilter(Predicate f) {
        Fetchable<?> p = this.createQuery(f);
        try {
            int n = p.fetch().size();
            return n;
        }
        finally {
            this.close(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runFilterDistinct(Predicate f) {
        Fetchable<?> p = this.createQuery(f);
        try {
            ((QueryBase)p).distinct();
            int n = p.fetch().size();
            return n;
        }
        finally {
            this.close(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runProjection(Expression<?> pr) {
        Fetchable<?> p = this.createQuery();
        try {
            ((FetchableQuery)p).select(pr);
            int n = p.fetch().size();
            return n;
        }
        finally {
            this.close(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runProjectionDistinct(Expression<?> pr) {
        Fetchable<?> p = this.createQuery();
        try {
            ((QueryBase)p).distinct();
            ((FetchableQuery)p).select(pr);
            int n = p.fetch().size();
            return n;
        }
        finally {
            this.close(p);
        }
    }

    private void close(Fetchable p) {
        if (p instanceof Closeable) {
            Closeable closeable = (Closeable)p;
            try {
                closeable.close();
            }
            catch (IOException e) {
                throw new QueryException((Throwable)e);
            }
        }
    }

    public final void report() {
        if (!this.failures.isEmpty() || !this.errors.isEmpty()) {
            System.err.println(this.failures.size() + " failures");
            for (String f : this.failures) {
                System.err.println(f);
            }
            System.err.println();
            System.err.println(this.errors.size() + " errors");
            for (String e : this.errors) {
                System.err.println(e);
            }
            StringBuilder buffer = new StringBuilder("Failed with ");
            if (!this.failures.isEmpty()) {
                buffer.append(this.failures.size()).append(" failure(s) ");
                if (!this.errors.isEmpty()) {
                    buffer.append("and ");
                }
            }
            if (!this.errors.isEmpty()) {
                buffer.append(this.errors.size()).append(" error(s) ");
            }
            buffer.append("of ").append(this.total).append(" tests\n");
            for (String f : this.failures) {
                buffer.append(f).append("\n");
            }
            for (String e : this.errors) {
                buffer.append(e).append("\n");
            }
            Assertions.fail((String)"", (Object[])new Object[]{buffer.toString()});
        } else {
            System.out.println("Success with " + this.total + " tests");
        }
    }

    public final QueryExecution noFilters() {
        this.runFilters = false;
        return this;
    }

    public final QueryExecution noProjections() {
        this.runProjections = false;
        return this;
    }

    public final QueryExecution noCounts() {
        this.counts = false;
        return this;
    }

    public final <A> void runArrayTests(ArrayExpression<A[], A> expr, ArrayExpression<A[], A> other, A knownElement, A missingElement) {
        this.runFilterQueries(this.matchers.array(expr, other, knownElement, missingElement), true);
        this.runFilterQueries(this.filters.array(expr, other, knownElement), false);
        this.runProjectionQueries(this.projections.array(expr, other, knownElement));
    }

    public final void runBooleanTests(BooleanExpression expr, BooleanExpression other) {
        this.runFilterQueries(this.filters.booleanFilters(expr, other), false);
    }

    public final <A> void runCollectionTests(CollectionExpressionBase<?, A> expr, CollectionExpression<?, A> other, A knownElement, A missingElement) {
        this.runFilterQueries(this.matchers.collection(expr, other, knownElement, missingElement), true);
        this.runFilterQueries(this.filters.collection(expr, other, knownElement), false);
        this.runProjectionQueries(this.projections.collection(expr, other, knownElement));
    }

    public final void runDateTests(DateExpression<Date> expr, DateExpression<Date> other, Date knownValue) {
        this.runFilterQueries(this.matchers.date(expr, other, knownValue), true);
        this.runFilterQueries(this.filters.date(expr, other, knownValue), false);
        this.runProjectionQueries(this.projections.date(expr, other, knownValue));
    }

    public final void runDateTimeTests(DateTimeExpression<java.util.Date> expr, DateTimeExpression<java.util.Date> other, java.util.Date knownValue) {
        this.runFilterQueries(this.matchers.dateTime(expr, other, knownValue), true);
        this.runFilterQueries(this.filters.dateTime(expr, other, knownValue), false);
        this.runProjectionQueries(this.projections.dateTime(expr, other, knownValue));
    }

    public final <A, Q extends SimpleExpression<A>> void runListTests(ListPath<A, Q> expr, ListExpression<A, Q> other, A knownElement, A missingElement) {
        this.runFilterQueries(this.matchers.list(expr, other, knownElement, missingElement), true);
        this.runFilterQueries(this.filters.list(expr, other, knownElement), false);
        this.runProjectionQueries(this.projections.list(expr, other, knownElement));
    }

    public final <K, V> void runMapTests(MapExpressionBase<K, V, ?> expr, MapExpression<K, V> other, K knownKey, V knownValue, K missingKey, V missingValue) {
        this.runFilterQueries(this.matchers.map(expr, other, knownKey, knownValue, missingKey, missingValue), true);
        this.runFilterQueries(this.filters.map(expr, other, knownKey, knownValue), false);
        this.runProjectionQueries(this.projections.map(expr, other, knownKey, knownValue));
    }

    public final <A extends Number> void runNumericCasts(NumberExpression<A> expr, NumberExpression<A> other, A knownValue) {
        this.runProjectionQueries(this.projections.numericCasts(expr, other, knownValue));
    }

    public final <A extends Number> void runNumericTests(NumberExpression<A> expr, NumberExpression<A> other, A knownValue) {
        this.runFilterQueries(this.matchers.numeric(expr, other, knownValue), true);
        this.runFilterQueries(this.filters.numeric(expr, other, knownValue), false);
        this.runProjectionQueries(this.projections.numeric(expr, other, knownValue, false));
    }

    public final void runStringTests(StringExpression expr, StringExpression other, String knownValue) {
        this.runFilterQueries(this.matchers.string(expr, other, knownValue), true);
        this.runFilterQueries(this.filters.string(expr, other, knownValue), false);
        this.runProjectionQueries(this.projections.string(expr, other, knownValue));
    }

    public final void runTimeTests(TimeExpression<Time> expr, TimeExpression<Time> other, Time knownValue) {
        this.runFilterQueries(this.matchers.time(expr, other, knownValue), true);
        this.runFilterQueries(this.filters.time(expr, other, knownValue), false);
        this.runProjectionQueries(this.projections.time(expr, other, knownValue));
    }
}

