/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.QueryModifiers;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class QueryModifiersTest {
    @Test
    public void limit() {
        QueryModifiers modifiers = QueryModifiers.limit((long)12L);
        Assertions.assertThat((Long)modifiers.getLimit()).isEqualTo((Object)12L);
        Assertions.assertThat((Long)modifiers.getOffset()).isNull();
        Assertions.assertThat((boolean)modifiers.isRestricting()).isTrue();
    }

    @Test
    public void offset() {
        QueryModifiers modifiers = QueryModifiers.offset((long)12L);
        Assertions.assertThat((Long)modifiers.getOffset()).isEqualTo((Object)12L);
        Assertions.assertThat((Long)modifiers.getLimit()).isNull();
        Assertions.assertThat((boolean)modifiers.isRestricting()).isTrue();
    }

    @Test
    public void both() {
        QueryModifiers modifiers = new QueryModifiers(Long.valueOf(1L), Long.valueOf(2L));
        Assertions.assertThat((Long)modifiers.getLimit()).isEqualTo((Object)1L);
        Assertions.assertThat((Long)modifiers.getOffset()).isEqualTo((Object)2L);
        Assertions.assertThat((boolean)modifiers.isRestricting()).isTrue();
    }

    @Test
    public void empty() {
        QueryModifiers modifiers = new QueryModifiers(null, null);
        Assertions.assertThat((Long)modifiers.getLimit()).isNull();
        Assertions.assertThat((Long)modifiers.getOffset()).isNull();
        Assertions.assertThat((boolean)modifiers.isRestricting()).isFalse();
    }

    @Test
    public void hashCode_() {
        QueryModifiers modifiers1 = new QueryModifiers(null, null);
        QueryModifiers modifiers2 = new QueryModifiers(Long.valueOf(1L), null);
        QueryModifiers modifiers3 = new QueryModifiers(null, Long.valueOf(1L));
        Assertions.assertThat((int)QueryModifiers.EMPTY.hashCode()).isEqualTo(modifiers1.hashCode());
        Assertions.assertThat((int)QueryModifiers.limit((long)1L).hashCode()).isEqualTo(modifiers2.hashCode());
        Assertions.assertThat((int)QueryModifiers.offset((long)1L).hashCode()).isEqualTo(modifiers3.hashCode());
    }

    @Test(expected=IllegalArgumentException.class)
    public void illegalLimit() {
        QueryModifiers.limit((long)-1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void illegalOffset() {
        QueryModifiers.offset((long)-1L);
    }

    @Test
    public void subList() {
        List<Integer> ints = Arrays.asList(1, 2, 3, 4, 5);
        Assertions.assertThat((List)QueryModifiers.offset((long)2L).subList(ints)).isEqualTo(Arrays.asList(3, 4, 5));
        Assertions.assertThat((List)QueryModifiers.limit((long)3L).subList(ints)).isEqualTo(Arrays.asList(1, 2, 3));
        Assertions.assertThat((List)new QueryModifiers(Long.valueOf(3L), Long.valueOf(1L)).subList(ints)).isEqualTo(Arrays.asList(2, 3, 4));
    }
}

