/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.QueryResults;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class QueryResultsTest {
    private List<Integer> list = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
    private QueryResults<Integer> results = new QueryResults(this.list, Long.valueOf(10L), Long.valueOf(0L), 20L);

    @Test
    public void getResults() {
        Assertions.assertThat((List)this.results.getResults()).isEqualTo(this.list);
    }

    @Test
    public void getTotal() {
        Assertions.assertThat((long)this.results.getTotal()).isEqualTo(20L);
    }

    @Test
    public void isEmpty() {
        Assertions.assertThat((boolean)this.results.isEmpty()).isFalse();
    }

    @Test
    public void getLimit() {
        Assertions.assertThat((long)this.results.getLimit()).isEqualTo(10L);
    }

    @Test
    public void getOffset() {
        Assertions.assertThat((long)this.results.getOffset()).isEqualTo(0L);
    }

    @Test
    public void emptyResults() {
        QueryResults empty = QueryResults.emptyResults();
        Assertions.assertThat((boolean)empty.isEmpty()).isTrue();
        Assertions.assertThat((long)empty.getLimit()).isEqualTo(Long.MAX_VALUE);
        Assertions.assertThat((long)empty.getOffset()).isEqualTo(0L);
        Assertions.assertThat((long)empty.getTotal()).isEqualTo(0L);
        Assertions.assertThat((List)empty.getResults()).isEqualTo(Collections.emptyList());
    }
}

