/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import com.querydsl.core.types.Templates;
import io.github.classgraph.ClassGraph;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;

public class TemplatesTestBase {
    @Rule
    public final ErrorCollector errorCollector = new ErrorCollector();
    private final ClassGraph querydsl = new ClassGraph().enableClassInfo().acceptPackages(new String[]{TemplatesTestBase.class.getPackage().getName()});
    private final String modulePrefix = this.getClass().getPackage().getName();
    private final Predicate<Class<?>> objectPredicate = o -> Pattern.matches("class " + this.modulePrefix + ".*", o.toString());
    private final Predicate<Class<?>> MODULE_SPECIFIC = this.objectPredicate.and(topLevelClass);
    private static final Predicate<Class<?>> topLevelClass = input -> !input.isAnonymousClass() && !input.isMemberClass();

    @Test
    public void default_instance() {
        List templates = this.querydsl.scan().getSubclasses(Templates.class.getName()).loadClasses();
        Set moduleSpecific = templates.stream().filter(this.MODULE_SPECIFIC).collect(Collectors.toSet());
        for (Class template : moduleSpecific) {
            try {
                Templates defaultInstance = (Templates)template.getField("DEFAULT").get(null);
                this.errorCollector.checkSucceeds(() -> (ObjectAssert)Assertions.assertThat((Object)defaultInstance).isInstanceOf(template));
            }
            catch (Exception ex) {
                this.errorCollector.addError((Throwable)ex);
            }
        }
    }
}

