/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.alias;

import com.querydsl.core.alias.Alias;
import com.querydsl.core.alias.ComparableEntity;
import com.querydsl.core.alias.DomainType;
import com.querydsl.core.alias.Gender;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.ComparablePath;
import com.querydsl.core.types.dsl.StringPath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class AliasTest {
    @Test
    public void alias() {
        DomainType domainType = (DomainType)Alias.alias(DomainType.class);
        Alias.alias(DomainType.class, (Expression)Alias.$(domainType.getCollection()).any());
    }

    @Test
    public void comparableEntity() {
        ComparableEntity entity = (ComparableEntity)Alias.alias(ComparableEntity.class);
        ComparablePath path = Alias.$((Comparable)entity);
        Assertions.assertThat((Class)path.getType()).isEqualTo(ComparableEntity.class);
    }

    @Test
    public void comparableEntity_property() {
        ComparableEntity entity = (ComparableEntity)Alias.alias(ComparableEntity.class);
        StringPath propertyPath = Alias.$((String)entity.getProperty());
        Assertions.assertThat((Class)propertyPath.getType()).isEqualTo(String.class);
        Assertions.assertThat((String)propertyPath.getMetadata().getName()).isEqualTo("property");
    }

    @Test
    public void basicUsage() {
        DomainType domainType = (DomainType)Alias.alias(DomainType.class);
        Assertions.assertThat((String)Alias.$((String)domainType.getFirstName()).lower().toString()).isEqualTo("lower(domainType.firstName)");
        Assertions.assertThat((String)Alias.$((Integer)domainType.getAge()).toString()).isEqualTo("domainType.age");
        Assertions.assertThat((String)Alias.$((Object)domainType.getMap().get("a")).toString()).isEqualTo("domainType.map.get(a)");
        Assertions.assertThat((String)Alias.$((Object)domainType.getList().get(0)).toString()).isEqualTo("domainType.list.get(0)");
        Assertions.assertThat((String)Alias.$((BigDecimal)domainType.getBigDecimal()).toString()).isEqualTo("domainType.bigDecimal");
        Assertions.assertThat((String)Alias.$((BigInteger)domainType.getBigInteger()).toString()).isEqualTo("domainType.bigInteger");
        Assertions.assertThat((String)Alias.$((Byte)domainType.getByte()).toString()).isEqualTo("domainType.byte");
        Assertions.assertThat((String)Alias.$(domainType.getCollection()).toString()).isEqualTo("domainType.collection");
        Assertions.assertThat((String)Alias.$((Double)domainType.getDouble()).toString()).isEqualTo("domainType.double");
        Assertions.assertThat((String)Alias.$((Float)domainType.getFloat()).toString()).isEqualTo("domainType.float");
        Assertions.assertThat((String)Alias.$((Date)domainType.getDate()).toString()).isEqualTo("domainType.date");
        Assertions.assertThat((String)Alias.$((java.util.Date)domainType.getDate2()).toString()).isEqualTo("domainType.date2");
        Assertions.assertThat((String)Alias.$(domainType.getSet()).toString()).isEqualTo("domainType.set");
        Assertions.assertThat((String)Alias.$((Short)domainType.getShort()).toString()).isEqualTo("domainType.short");
        Assertions.assertThat((String)Alias.$((Time)domainType.getTime()).toString()).isEqualTo("domainType.time");
        Assertions.assertThat((String)Alias.$((Timestamp)domainType.getTimestamp()).toString()).isEqualTo("domainType.timestamp");
        Assertions.assertThat((String)Alias.$((Enum)domainType.getGender()).toString()).isEqualTo("domainType.gender");
    }

    @Test
    public void getAny() {
        DomainType domainType = (DomainType)Alias.alias(DomainType.class);
        Assertions.assertThat((Class)Alias.getAny((Object)domainType).getType()).isEqualTo(DomainType.class);
        Assertions.assertThat((Class)Alias.getAny((Object)domainType.getFirstName()).getType()).isEqualTo(String.class);
    }

    @Test
    public void otherMethods() {
        DomainType domainType = (DomainType)Alias.alias(DomainType.class);
        Assertions.assertThat((String)domainType.toString()).isEqualTo("domainType");
    }

    @Test
    public void var() {
        Assertions.assertThat((String)Alias.var().toString()).isEqualTo("it");
        Assertions.assertThat((String)Alias.var((Number)1).toString()).isEqualTo("varInteger1");
        Assertions.assertThat((String)Alias.var((String)"X").toString()).isEqualTo("X");
        Assertions.assertThat((String)Alias.var((Comparable)((Object)Gender.MALE)).toString()).isEqualTo("varMALE");
        Assertions.assertThat((String)Alias.var((Object)new AliasTest()).toString()).isEqualTo("varAliasTest_XXX");
    }

    public String toString() {
        return "XXX";
    }
}

