/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.group;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.commons.lang.Pair;
import com.querydsl.core.Tuple;
import com.querydsl.core.group.AbstractGroupByTest;
import com.querydsl.core.group.Group;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.group.GroupExpression;
import com.querydsl.core.group.Post;
import com.querydsl.core.group.User;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Projections;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class GroupByIterateTest
extends AbstractGroupByTest {
    @Override
    @Test
    public void group_order() {
        CloseableIterator resultsIt = (CloseableIterator)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).iterate(new Expression[]{postName, GroupBy.set((Expression)commentId)}));
        List results = IteratorAdapter.asList((Iterator)resultsIt);
        Assertions.assertThat((List)results).hasSize(4);
    }

    @Override
    @Test
    public void first_set_and_list() {
        CloseableIterator resultsIt = (CloseableIterator)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).iterate(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        List results = IteratorAdapter.asList((Iterator)resultsIt);
        Assertions.assertThat((List)results).hasSize(4);
        Group group = (Group)results.get(1);
        Assertions.assertThat((Integer)((Integer)group.getOne((Expression)postId))).isEqualTo((Object)this.toInt(1));
        Assertions.assertThat((String)((String)group.getOne((Expression)postName))).isEqualTo("post 1");
        Assertions.assertThat((Collection)group.getSet((Expression)commentId)).isEqualTo(this.toSet(1, 2, 3));
        Assertions.assertThat((List)group.getList((Expression)commentText)).isEqualTo(Arrays.asList("comment 1", "comment 2", "comment 3"));
    }

    @Override
    @Test
    public void group_by_null() {
        CloseableIterator resultsIt = (CloseableIterator)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).iterate(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        List results = IteratorAdapter.asList((Iterator)resultsIt);
        Assertions.assertThat((List)results).hasSize(4);
        Group group = (Group)results.getFirst();
        Assertions.assertThat((Integer)((Integer)group.getOne((Expression)postId))).isNull();
        Assertions.assertThat((String)((String)group.getOne((Expression)postName))).isEqualTo("null post");
        Assertions.assertThat((Collection)group.getSet((Expression)commentId)).isEqualTo(this.toSet(7, 8));
        Assertions.assertThat((List)group.getList((Expression)commentText)).isEqualTo(Arrays.asList("comment 7", "comment 8"));
    }

    @Override
    @Test(expected=NoSuchElementException.class)
    public void noSuchElementException() {
        CloseableIterator resultsIt = (CloseableIterator)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).iterate(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        List results = IteratorAdapter.asList((Iterator)resultsIt);
        Assertions.assertThat((List)results).hasSize(4);
        Group group = (Group)results.get(1);
        group.getSet((Expression)qComment);
    }

    @Override
    @Test(expected=ClassCastException.class)
    public void classCastException() {
        CloseableIterator resultsIt = (CloseableIterator)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).iterate(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        List results = IteratorAdapter.asList((Iterator)resultsIt);
        Assertions.assertThat((List)results).hasSize(4);
        Group group = (Group)results.get(1);
        group.getList((Expression)commentId);
    }

    @Override
    @Test
    public void map1() {
        CloseableIterator resultsIt = (CloseableIterator)MAP_RESULTS.transform(GroupBy.groupBy((Expression)postId).iterate(new Expression[]{postName, GroupBy.map((Expression)commentId, (Expression)commentText)}));
        List results = IteratorAdapter.asList((Iterator)resultsIt);
        Assertions.assertThat((List)results).hasSize(4);
        Group group = (Group)results.get(1);
        Map comments = group.getMap((Expression)commentId, (Expression)commentText);
        Assertions.assertThat((Map)comments).hasSize(3);
        Assertions.assertThat((Map)comments).containsEntry((Object)2, (Object)"comment 2");
    }

    @Override
    @Test
    public void map2() {
        CloseableIterator resultsIt = (CloseableIterator)MAP2_RESULTS.transform(GroupBy.groupBy((Expression)postId).iterate((Expression)GroupBy.map((Expression)commentId, (Expression)commentText)));
        List results = IteratorAdapter.asList((Iterator)resultsIt);
        Assertions.assertThat((List)results).hasSize(4);
        Map comments = (Map)results.get(1);
        Assertions.assertThat((Map)comments).hasSize(3);
        Assertions.assertThat((Map)comments).containsEntry((Object)2, (Object)"comment 2");
    }

    @Test
    public void map22() {
        CloseableIterator results = (CloseableIterator)MAP2_RESULTS.transform(GroupBy.groupBy((Expression)postId).iterate((Expression)GroupBy.map((Expression)commentId, (Expression)commentText)));
        List actual = IteratorAdapter.asList((Iterator)results);
        Object commentId = null;
        LinkedHashMap<Integer, String> comments = null;
        LinkedList expected = new LinkedList();
        CloseableIterator iterator = MAP2_RESULTS.iterate();
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            Object[] array = tuple.toArray();
            if (comments == null || commentId != array[0] && (commentId == null || !commentId.equals(array[0]))) {
                comments = new LinkedHashMap<Integer, String>();
                expected.add(comments);
            }
            commentId = array[0];
            Pair pair = (Pair)array[1];
            comments.put((Integer)pair.getFirst(), (String)pair.getSecond());
        }
        Assertions.assertThat((String)actual.toString()).isEqualTo(((Object)expected).toString());
    }

    @Override
    @Test
    public void map3() {
        CloseableIterator results = (CloseableIterator)MAP3_RESULTS.transform(GroupBy.groupBy((Expression)postId).iterate((Expression)GroupBy.map((Expression)postId, (GroupExpression)GroupBy.map((Expression)commentId, (Expression)commentText))));
        List actual = IteratorAdapter.asList((Iterator)results);
        Object postId = null;
        LinkedHashMap<Integer, Map> posts = null;
        LinkedList expected = new LinkedList();
        CloseableIterator iterator = MAP3_RESULTS.iterate();
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            Object[] array = tuple.toArray();
            if (posts == null || postId != array[0] && (postId == null || !postId.equals(array[0]))) {
                posts = new LinkedHashMap<Integer, Map>();
                expected.add(posts);
            }
            postId = array[0];
            Pair pair = (Pair)array[1];
            Integer first = (Integer)pair.getFirst();
            Map comments = posts.computeIfAbsent(first, k -> new LinkedHashMap());
            Pair second = (Pair)pair.getSecond();
            comments.put((Integer)second.getFirst(), (String)second.getSecond());
        }
        Assertions.assertThat((String)actual.toString()).isEqualTo(((Object)expected).toString());
    }

    @Override
    @Test
    public void map4() {
        CloseableIterator results = (CloseableIterator)MAP4_RESULTS.transform(GroupBy.groupBy((Expression)postId).iterate((Expression)GroupBy.map((GroupExpression)GroupBy.map((Expression)postId, (Expression)commentText), (Expression)postName)));
        List actual = IteratorAdapter.asList((Iterator)results);
        Object commentId = null;
        LinkedHashMap<Map<Integer, String>, String> comments = null;
        LinkedList expected = new LinkedList();
        CloseableIterator iterator = MAP4_RESULTS.iterate();
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            Object[] array = tuple.toArray();
            if (comments == null || commentId != array[0] && (commentId == null || !commentId.equals(array[0]))) {
                comments = new LinkedHashMap<Map<Integer, String>, String>();
                expected.add(comments);
            }
            commentId = array[0];
            Pair pair = (Pair)array[1];
            Pair first = (Pair)pair.getFirst();
            Map<Integer, String> posts = Collections.singletonMap((Integer)first.getFirst(), (String)first.getSecond());
            comments.put(posts, (String)pair.getSecond());
        }
        Assertions.assertThat((String)actual.toString()).isEqualTo(((Object)expected).toString());
    }

    @Override
    @Test
    public void array_access() {
        CloseableIterator resultsIt = (CloseableIterator)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).iterate(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        List results = IteratorAdapter.asList((Iterator)resultsIt);
        Assertions.assertThat((List)results).hasSize(4);
        Group group = (Group)results.get(1);
        Object[] array = group.toArray();
        Assertions.assertThat((Object)array[0]).isEqualTo((Object)this.toInt(1));
        Assertions.assertThat((Object)array[1]).isEqualTo((Object)"post 1");
        Assertions.assertThat((Object)array[2]).isEqualTo(this.toSet(1, 2, 3));
        Assertions.assertThat((Object)array[3]).isEqualTo(Arrays.asList("comment 1", "comment 2", "comment 3"));
    }

    @Override
    @Test
    public void transform_results() {
        CloseableIterator resultsIt = (CloseableIterator)POST_W_COMMENTS.transform(GroupBy.groupBy((Expression)postId).iterate((FactoryExpression)Projections.constructor(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment)})));
        List results = IteratorAdapter.asList((Iterator)resultsIt);
        Assertions.assertThat((List)results).hasSize(4);
        Post post = (Post)results.get(1);
        Assertions.assertThat((Object)post).isNotNull();
        Assertions.assertThat((Integer)post.getId()).isEqualTo((Object)this.toInt(1));
        Assertions.assertThat((String)post.getName()).isEqualTo("post 1");
        Assertions.assertThat(post.getComments()).isEqualTo(this.toSet(GroupByIterateTest.comment(1), GroupByIterateTest.comment(2), GroupByIterateTest.comment(3)));
    }

    @Override
    @Test
    public void transform_as_bean() {
        CloseableIterator resultsIt = (CloseableIterator)POST_W_COMMENTS.transform(GroupBy.groupBy((Expression)postId).iterate((FactoryExpression)Projections.bean(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment).as("comments")})));
        List results = IteratorAdapter.asList((Iterator)resultsIt);
        Assertions.assertThat((List)results).hasSize(4);
        Post post = (Post)results.get(1);
        Assertions.assertThat((Object)post).isNotNull();
        Assertions.assertThat((Integer)post.getId()).isEqualTo((Object)this.toInt(1));
        Assertions.assertThat((String)post.getName()).isEqualTo("post 1");
        Assertions.assertThat(post.getComments()).isEqualTo(this.toSet(GroupByIterateTest.comment(1), GroupByIterateTest.comment(2), GroupByIterateTest.comment(3)));
    }

    @Override
    @Test
    public void oneToOneToMany_projection() {
        CloseableIterator resultsIt = (CloseableIterator)USERS_W_LATEST_POST_AND_COMMENTS.transform(GroupBy.groupBy((Expression)userName).iterate((FactoryExpression)Projections.constructor(User.class, (Expression[])new Expression[]{userName, Projections.constructor(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment)})})));
        List results = IteratorAdapter.asList((Iterator)resultsIt);
        Assertions.assertThat((List)results).hasSize(2);
        User user = (User)results.getFirst();
        Post post = user.getLatestPost();
        Assertions.assertThat((Integer)post.getId()).isEqualTo((Object)this.toInt(2));
        Assertions.assertThat((String)post.getName()).isEqualTo("post 2");
        Assertions.assertThat(post.getComments()).isEqualTo(this.toSet(GroupByIterateTest.comment(4), GroupByIterateTest.comment(5)));
    }

    @Override
    @Test
    public void oneToOneToMany_projection_as_bean() {
        CloseableIterator resultsIt = (CloseableIterator)USERS_W_LATEST_POST_AND_COMMENTS.transform(GroupBy.groupBy((Expression)userName).iterate((FactoryExpression)Projections.bean(User.class, (Expression[])new Expression[]{userName, Projections.bean(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment).as("comments")}).as("latestPost")})));
        List results = IteratorAdapter.asList((Iterator)resultsIt);
        Assertions.assertThat((List)results).hasSize(2);
        User user = (User)results.getFirst();
        Post post = user.getLatestPost();
        Assertions.assertThat((Integer)post.getId()).isEqualTo((Object)this.toInt(2));
        Assertions.assertThat((String)post.getName()).isEqualTo("post 2");
        Assertions.assertThat(post.getComments()).isEqualTo(this.toSet(GroupByIterateTest.comment(4), GroupByIterateTest.comment(5)));
    }

    @Override
    @Test
    public void oneToOneToMany_projection_as_bean_and_constructor() {
        CloseableIterator resultsIt = (CloseableIterator)USERS_W_LATEST_POST_AND_COMMENTS.transform(GroupBy.groupBy((Expression)userName).iterate((FactoryExpression)Projections.bean(User.class, (Expression[])new Expression[]{userName, Projections.constructor(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment)}).as("latestPost")})));
        List results = IteratorAdapter.asList((Iterator)resultsIt);
        Assertions.assertThat((List)results).hasSize(2);
        User user = (User)results.getFirst();
        Post post = user.getLatestPost();
        Assertions.assertThat((Integer)post.getId()).isEqualTo((Object)this.toInt(2));
        Assertions.assertThat((String)post.getName()).isEqualTo("post 2");
        Assertions.assertThat(post.getComments()).isEqualTo(this.toSet(GroupByIterateTest.comment(4), GroupByIterateTest.comment(5)));
    }
}

