/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.group;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.Pair;
import com.querydsl.core.ResultTransformer;
import com.querydsl.core.Tuple;
import com.querydsl.core.group.AbstractGroupByTest;
import com.querydsl.core.group.GOne;
import com.querydsl.core.group.Group;
import com.querydsl.core.group.GroupBy;
import com.querydsl.core.group.GroupByProjection;
import com.querydsl.core.group.GroupExpression;
import com.querydsl.core.group.Post;
import com.querydsl.core.group.User;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class GroupByMapTest
extends AbstractGroupByTest {
    @Test
    public void compile() {
        StringPath str = Expressions.stringPath((String)"str");
        GOne strGroup = new GOne((Expression)str);
        GroupBy.sortedMap((GroupExpression)strGroup, (Expression)str, null);
        GroupBy.sortedMap((Expression)str, (GroupExpression)strGroup, null);
    }

    @Override
    @Test
    public void group_order() {
        Map results = (Map)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.set((Expression)commentId)}));
        Assertions.assertThat((Map)results).hasSize(4);
    }

    @Test
    public void set_by_sorted() {
        Map results = (Map)BASIC_RESULTS_UNORDERED.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.sortedSet((Expression)commentId)}));
        Group group = (Group)results.get(1);
        Iterator it = group.getSet((Expression)commentId).iterator();
        Assertions.assertThat((int)((Integer)it.next())).isEqualTo(1);
        Assertions.assertThat((int)((Integer)it.next())).isEqualTo(2);
        Assertions.assertThat((int)((Integer)it.next())).isEqualTo(3);
    }

    @Test
    public void set_by_sorted_reverse() {
        Map results = (Map)BASIC_RESULTS_UNORDERED.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.sortedSet((Expression)commentId, Comparator.reverseOrder())}));
        Group group = (Group)results.get(1);
        Iterator it = group.getSet((Expression)commentId).iterator();
        Assertions.assertThat((int)((Integer)it.next())).isEqualTo(3);
        Assertions.assertThat((int)((Integer)it.next())).isEqualTo(2);
        Assertions.assertThat((int)((Integer)it.next())).isEqualTo(1);
    }

    @Override
    @Test
    public void first_set_and_list() {
        Map results = (Map)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        Group group = (Group)results.get(1);
        Assertions.assertThat((Integer)((Integer)group.getOne((Expression)postId))).isEqualTo((Object)this.toInt(1));
        Assertions.assertThat((String)((String)group.getOne((Expression)postName))).isEqualTo("post 1");
        Assertions.assertThat((Collection)group.getSet((Expression)commentId)).isEqualTo(this.toSet(1, 2, 3));
        Assertions.assertThat((List)group.getList((Expression)commentText)).isEqualTo(Arrays.asList("comment 1", "comment 2", "comment 3"));
    }

    @Override
    @Test
    public void group_by_null() {
        Map results = (Map)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        Group group = (Group)results.get(null);
        Assertions.assertThat((Integer)((Integer)group.getOne((Expression)postId))).isNull();
        Assertions.assertThat((String)((String)group.getOne((Expression)postName))).isEqualTo("null post");
        Assertions.assertThat((Collection)group.getSet((Expression)commentId)).isEqualTo(this.toSet(7, 8));
        Assertions.assertThat((List)group.getList((Expression)commentText)).isEqualTo(Arrays.asList("comment 7", "comment 8"));
    }

    @Override
    @Test(expected=NoSuchElementException.class)
    public void noSuchElementException() {
        Map results = (Map)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        Group group = (Group)results.get(1);
        group.getSet((Expression)qComment);
    }

    @Override
    @Test(expected=ClassCastException.class)
    public void classCastException() {
        Map results = (Map)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        Group group = (Group)results.get(1);
        group.getList((Expression)commentId);
    }

    @Override
    @Test
    public void map1() {
        Map results = (Map)MAP_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.map((Expression)commentId, (Expression)commentText)}));
        Group group = (Group)results.get(1);
        Map comments = group.getMap((Expression)commentId, (Expression)commentText);
        Assertions.assertThat((Map)comments).hasSize(3);
        Assertions.assertThat((Map)comments).containsEntry((Object)2, (Object)"comment 2");
    }

    @Test
    public void map_sorted() {
        Map results = (Map)MAP_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.sortedMap((Expression)commentId, (Expression)commentText)}));
        Group group = (Group)results.get(1);
        Iterator it = group.getMap((Expression)commentId, (Expression)commentText).entrySet().iterator();
        Assertions.assertThat((int)((Integer)it.next().getKey())).isEqualTo(1);
        Assertions.assertThat((int)((Integer)it.next().getKey())).isEqualTo(2);
        Assertions.assertThat((int)((Integer)it.next().getKey())).isEqualTo(3);
    }

    @Test
    public void map_sorted_reverse() {
        Map results = (Map)MAP_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.sortedMap((Expression)commentId, (Expression)commentText, Comparator.reverseOrder())}));
        Group group = (Group)results.get(1);
        Iterator it = group.getMap((Expression)commentId, (Expression)commentText).entrySet().iterator();
        Assertions.assertThat((int)((Integer)it.next().getKey())).isEqualTo(3);
        Assertions.assertThat((int)((Integer)it.next().getKey())).isEqualTo(2);
        Assertions.assertThat((int)((Integer)it.next().getKey())).isEqualTo(1);
    }

    @Override
    @Test
    public void map2() {
        Map results = (Map)MAP2_RESULTS.transform(GroupBy.groupBy((Expression)postId).as((Expression)GroupBy.map((Expression)commentId, (Expression)commentText)));
        Map comments = (Map)results.get(1);
        Assertions.assertThat((Map)comments).hasSize(3);
        Assertions.assertThat((Map)comments).containsEntry((Object)2, (Object)"comment 2");
    }

    @Override
    @Test
    public void map3() {
        Map actual = (Map)MAP3_RESULTS.transform(GroupBy.groupBy((Expression)postId).as((Expression)GroupBy.map((Expression)postId, (GroupExpression)GroupBy.map((Expression)commentId, (Expression)commentText))));
        LinkedHashMap expected = new LinkedHashMap();
        CloseableIterator iterator = MAP3_RESULTS.iterate();
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            Object[] array = tuple.toArray();
            LinkedHashMap<Integer, Map> posts = (LinkedHashMap<Integer, Map>)expected.get(array[0]);
            if (posts == null) {
                posts = new LinkedHashMap<Integer, Map>();
                expected.put((Integer)array[0], posts);
            }
            Pair pair = (Pair)array[1];
            Integer first = (Integer)pair.getFirst();
            Map comments = posts.computeIfAbsent(first, k -> new LinkedHashMap());
            Pair second = (Pair)pair.getSecond();
            comments.put((Integer)second.getFirst(), (String)second.getSecond());
        }
        Assertions.assertThat((String)actual.toString()).isEqualTo(((Object)expected).toString());
    }

    @Override
    @Test
    public void map4() {
        Map actual = (Map)MAP4_RESULTS.transform(GroupBy.groupBy((Expression)postId).as((Expression)GroupBy.map((GroupExpression)GroupBy.map((Expression)postId, (Expression)commentText), (Expression)postName)));
        LinkedHashMap expected = new LinkedHashMap();
        CloseableIterator iterator = MAP4_RESULTS.iterate();
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            Object[] array = tuple.toArray();
            LinkedHashMap<Map<Integer, String>, String> comments = (LinkedHashMap<Map<Integer, String>, String>)expected.get(array[0]);
            if (comments == null) {
                comments = new LinkedHashMap<Map<Integer, String>, String>();
                expected.put((Integer)array[0], comments);
            }
            Pair pair = (Pair)array[1];
            Pair first = (Pair)pair.getFirst();
            Map<Integer, String> posts = Collections.singletonMap((Integer)first.getFirst(), (String)first.getSecond());
            comments.put(posts, (String)pair.getSecond());
        }
        Assertions.assertThat((String)actual.toString()).isEqualTo(((Object)expected).toString());
    }

    @Override
    @Test
    public void array_access() {
        Map results = (Map)BASIC_RESULTS.transform(GroupBy.groupBy((Expression)postId).as(new Expression[]{postName, GroupBy.set((Expression)commentId), GroupBy.list((Expression)commentText)}));
        Group group = (Group)results.get(1);
        Object[] array = group.toArray();
        Assertions.assertThat((Object)array[0]).isEqualTo((Object)this.toInt(1));
        Assertions.assertThat((Object)array[1]).isEqualTo((Object)"post 1");
        Assertions.assertThat((Object)array[2]).isEqualTo(this.toSet(1, 2, 3));
        Assertions.assertThat((Object)array[3]).isEqualTo(Arrays.asList("comment 1", "comment 2", "comment 3"));
    }

    @Override
    @Test
    public void transform_results() {
        Map results = (Map)POST_W_COMMENTS.transform(GroupBy.groupBy((Expression)postId).as((FactoryExpression)Projections.constructor(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment)})));
        Post post = (Post)results.get(1);
        Assertions.assertThat((Object)post).isNotNull();
        Assertions.assertThat((Integer)post.getId()).isEqualTo((Object)this.toInt(1));
        Assertions.assertThat((String)post.getName()).isEqualTo("post 1");
        Assertions.assertThat(post.getComments()).isEqualTo(this.toSet(GroupByMapTest.comment(1), GroupByMapTest.comment(2), GroupByMapTest.comment(3)));
    }

    @Test
    public void transform_via_groupByProjection() {
        Map results = (Map)POST_W_COMMENTS2.transform(new GroupByProjection<Integer, Post>(this, (Expression)postId, new Expression[]{postName, GroupBy.set((Expression)qComment)}){

            protected Post transform(Group group) {
                return new Post((Integer)group.getOne(AbstractGroupByTest.postId), (String)group.getOne((Expression)AbstractGroupByTest.postName), group.getSet(AbstractGroupByTest.qComment));
            }
        });
        Post post = (Post)results.get(1);
        Assertions.assertThat((Object)post).isNotNull();
        Assertions.assertThat((Integer)post.getId()).isEqualTo((Object)this.toInt(1));
        Assertions.assertThat((String)post.getName()).isEqualTo("post 1");
        Assertions.assertThat(post.getComments()).isEqualTo(this.toSet(GroupByMapTest.comment(1), GroupByMapTest.comment(2), GroupByMapTest.comment(3)));
    }

    @Override
    @Test
    public void transform_as_bean() {
        Map results = (Map)POST_W_COMMENTS.transform(GroupBy.groupBy((Expression)postId).as((FactoryExpression)Projections.bean(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment).as("comments")})));
        Post post = (Post)results.get(1);
        Assertions.assertThat((Object)post).isNotNull();
        Assertions.assertThat((Integer)post.getId()).isEqualTo((Object)this.toInt(1));
        Assertions.assertThat((String)post.getName()).isEqualTo("post 1");
        Assertions.assertThat(post.getComments()).isEqualTo(this.toSet(GroupByMapTest.comment(1), GroupByMapTest.comment(2), GroupByMapTest.comment(3)));
    }

    @Override
    @Test
    public void oneToOneToMany_projection() {
        Map results = (Map)USERS_W_LATEST_POST_AND_COMMENTS.transform(GroupBy.groupBy((Expression)userName).as((FactoryExpression)Projections.constructor(User.class, (Expression[])new Expression[]{userName, Projections.constructor(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment)})})));
        Assertions.assertThat((Map)results).hasSize(2);
        User user = (User)results.get("Jane");
        Post post = user.getLatestPost();
        Assertions.assertThat((Integer)post.getId()).isEqualTo((Object)this.toInt(2));
        Assertions.assertThat((String)post.getName()).isEqualTo("post 2");
        Assertions.assertThat(post.getComments()).isEqualTo(this.toSet(GroupByMapTest.comment(4), GroupByMapTest.comment(5)));
    }

    @Override
    @Test
    public void oneToOneToMany_projection_as_bean() {
        Map results = (Map)USERS_W_LATEST_POST_AND_COMMENTS.transform(GroupBy.groupBy((Expression)userName).as((FactoryExpression)Projections.bean(User.class, (Expression[])new Expression[]{userName, Projections.bean(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment).as("comments")}).as("latestPost")})));
        Assertions.assertThat((Map)results).hasSize(2);
        User user = (User)results.get("Jane");
        Post post = user.getLatestPost();
        Assertions.assertThat((Integer)post.getId()).isEqualTo((Object)this.toInt(2));
        Assertions.assertThat((String)post.getName()).isEqualTo("post 2");
        Assertions.assertThat(post.getComments()).isEqualTo(this.toSet(GroupByMapTest.comment(4), GroupByMapTest.comment(5)));
    }

    @Override
    @Test
    public void oneToOneToMany_projection_as_bean_and_constructor() {
        Map results = (Map)USERS_W_LATEST_POST_AND_COMMENTS.transform(GroupBy.groupBy((Expression)userName).as((FactoryExpression)Projections.bean(User.class, (Expression[])new Expression[]{userName, Projections.constructor(Post.class, (Expression[])new Expression[]{postId, postName, GroupBy.set((Expression)qComment)}).as("latestPost")})));
        Assertions.assertThat((Map)results).hasSize(2);
        User user = (User)results.get("Jane");
        Post post = user.getLatestPost();
        Assertions.assertThat((Integer)post.getId()).isEqualTo((Object)this.toInt(2));
        Assertions.assertThat((String)post.getName()).isEqualTo("post 2");
        Assertions.assertThat(post.getComments()).isEqualTo(this.toSet(GroupByMapTest.comment(4), GroupByMapTest.comment(5)));
    }

    @Test
    public void signature() {
        StringPath str = Expressions.stringPath((String)"str");
        NumberPath bigd = Expressions.numberPath(BigDecimal.class, (String)"bigd");
        ResultTransformer resultTransformer = GroupBy.groupBy((Expression)str).as((Expression)GroupBy.sortedMap((Expression)bigd, (GroupExpression)GroupBy.sortedMap((Expression)bigd, (GroupExpression)GroupBy.map((Expression)str, (Expression)str), Comparator.nullsLast(Comparator.naturalOrder())), Comparator.nullsFirst(Comparator.naturalOrder())));
        Assertions.assertThat((Object)resultTransformer).isNotNull();
    }

    @Test
    public void average_with_default_math_context() {
        Map results = (Map)POSTS_W_COMMENTS_SCORE.transform(GroupBy.groupBy((Expression)postId).as((Expression)GroupBy.avg((Expression)score)));
        Assertions.assertThat((Double)((Double)results.get(null))).isCloseTo(1.5, Assertions.within((Double)0.0));
        Assertions.assertThat((Double)((Double)results.get(1))).isCloseTo(1.3333333333333333, Assertions.within((Double)0.0));
        Assertions.assertThat((Double)((Double)results.get(2))).isCloseTo(1.5, Assertions.within((Double)0.0));
    }

    @Test
    public void average_with_user_provided_math_context() {
        MathContext oneDigitMathContext = new MathContext(2, RoundingMode.HALF_EVEN);
        Map results = (Map)POSTS_W_COMMENTS_SCORE.transform(GroupBy.groupBy((Expression)postId).as((Expression)GroupBy.avg((Expression)score, (MathContext)oneDigitMathContext)));
        Assertions.assertThat((Double)((Double)results.get(null))).isCloseTo(1.5, Assertions.within((Double)0.0));
        Assertions.assertThat((Double)((Double)results.get(1))).isCloseTo(1.3, Assertions.within((Double)0.0));
        Assertions.assertThat((Double)((Double)results.get(2))).isCloseTo(1.5, Assertions.within((Double)0.0));
    }
}

