/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.support;

import com.querydsl.core.domain.QCat;
import com.querydsl.core.support.CollectionAnyVisitor;
import com.querydsl.core.support.Context;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.TemplateExpression;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.BooleanExpression;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class CollectionAnyVisitorTest {
    private QCat cat = QCat.cat;

    @Test
    public void path() {
        Assertions.assertThat((String)this.serialize((Expression<?>)this.cat.kittens.any())).isEqualTo("cat_kittens_0");
    }

    @Test
    public void longer_path() {
        Assertions.assertThat((String)this.serialize((Expression<?>)((QCat)this.cat.kittens.any()).name)).isEqualTo("cat_kittens_0.name");
    }

    @Test
    public void longer_path2() {
        CollectionAnyVisitor visitor = new CollectionAnyVisitor();
        Assertions.assertThat((String)this.serialize((Expression<?>)((QCat)this.cat.kittens.any()).name, visitor)).isEqualTo("cat_kittens_0.name");
        Assertions.assertThat((String)this.serialize((Expression<?>)((QCat)this.cat.kittens.any()).name, visitor)).isEqualTo("cat_kittens_1.name");
    }

    @Test
    public void very_long_path() {
        Assertions.assertThat((String)this.serialize((Expression<?>)((QCat)((QCat)this.cat.kittens.any()).kittens.any()).name)).isEqualTo("cat_kittens_0_kittens_1.name");
    }

    @Test
    public void simple_booleanOperation() {
        BooleanExpression predicate = ((QCat)this.cat.kittens.any()).name.eq((Object)"Ruth123");
        Assertions.assertThat((String)this.serialize((Expression<?>)predicate)).isEqualTo("cat_kittens_0.name = Ruth123");
    }

    @Test
    public void simple_stringOperation() {
        BooleanExpression predicate = ((QCat)this.cat.kittens.any()).name.substring(1).eq((Object)"uth123");
        Assertions.assertThat((String)this.serialize((Expression<?>)predicate)).isEqualTo("substring(cat_kittens_0.name,1) = uth123");
    }

    @Test
    public void and_operation() {
        BooleanExpression predicate = ((QCat)this.cat.kittens.any()).name.eq((Object)"Ruth123").and((Predicate)((QCat)this.cat.kittens.any()).bodyWeight.gt((Number)10.0));
        Assertions.assertThat((String)this.serialize((Expression<?>)predicate)).isEqualTo("cat_kittens_0.name = Ruth123 && cat_kittens_1.bodyWeight > 10.0");
    }

    @Test
    public void template() {
        TemplateExpression templateExpr = ExpressionUtils.template(Boolean.class, (String)"{0} = {1}", (Object[])new Object[]{((QCat)this.cat.kittens.any()).name, ConstantImpl.create((Object)"Ruth123")});
        Assertions.assertThat((String)this.serialize((Expression<?>)templateExpr)).isEqualTo("cat_kittens_0.name = Ruth123");
    }

    private String serialize(Expression<?> expression) {
        return this.serialize(expression, new CollectionAnyVisitor());
    }

    private String serialize(Expression<?> expression, CollectionAnyVisitor visitor) {
        Expression transformed = (Expression)expression.accept((Visitor)visitor, (Object)new Context());
        return transformed.toString();
    }
}

