/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.support;

import com.querydsl.core.support.EnumConversion;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringPath;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class EnumConversionTest {
    @Test
    public void nameForCharacter() {
        EnumPath color = Expressions.enumPath(Color.class, (String)"path");
        EnumConversion conv = new EnumConversion((Expression)color);
        Assertions.assertThat((Comparable)((Object)((Color)((Object)conv.newInstance(new Object[]{Character.valueOf('W')}))))).isEqualTo((Object)Color.W);
    }

    @Test
    public void name() {
        EnumPath color = Expressions.enumPath(Color.class, (String)"path");
        EnumConversion conv = new EnumConversion((Expression)color);
        Assertions.assertThat((Comparable)((Object)((Color)((Object)conv.newInstance(new Object[]{"BLUE"}))))).isEqualTo((Object)Color.BLUE);
    }

    @Test
    public void ordinal() {
        EnumPath color = Expressions.enumPath(Color.class, (String)"path");
        EnumConversion conv = new EnumConversion((Expression)color);
        Assertions.assertThat((Comparable)((Object)((Color)((Object)conv.newInstance(new Object[]{2}))))).isEqualTo((Object)Color.RED);
    }

    @Test(expected=IllegalArgumentException.class)
    public void illegal() {
        StringPath string = Expressions.stringPath((String)"path");
        EnumConversion conv = new EnumConversion((Expression)string);
        Assertions.fail((String)"EnumConversion successfully created for a non-enum type");
        conv.newInstance(new Object[]{0});
    }

    public static enum Color {
        GREEN,
        BLUE,
        RED,
        YELLOW,
        B,
        W;

    }
}

