/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.support;

import com.querydsl.core.Tuple;
import com.querydsl.core.support.NumberConversions;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QTuple;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class NumberConversionsTest {
    @Test
    public void name() {
        EnumPath color = Expressions.enumPath(Color.class, (String)"path");
        QTuple qTuple = Projections.tuple((Expression[])new Expression[]{color});
        NumberConversions conversions = new NumberConversions((FactoryExpression)qTuple);
        Assertions.assertThat((Comparable)((Object)((Color)((Object)((Tuple)conversions.newInstance(new Object[]{"BLUE"})).get((Expression)color))))).isEqualTo((Object)Color.BLUE);
    }

    @Test
    public void ordinal() {
        EnumPath color = Expressions.enumPath(Color.class, (String)"path");
        QTuple qTuple = Projections.tuple((Expression[])new Expression[]{color});
        NumberConversions conversions = new NumberConversions((FactoryExpression)qTuple);
        Assertions.assertThat((Comparable)((Object)((Color)((Object)((Tuple)conversions.newInstance(new Object[]{2})).get((Expression)color))))).isEqualTo((Object)Color.RED);
    }

    @Test
    public void safe_number_conversion() {
        StringPath strPath = Expressions.stringPath((String)"strPath");
        NumberPath intPath = Expressions.numberPath(Integer.class, (String)"intPath");
        QTuple qTuple = Projections.tuple((Expression[])new Expression[]{strPath, intPath});
        NumberConversions conversions = new NumberConversions((FactoryExpression)qTuple);
        Assertions.assertThat((Object)((Tuple)conversions.newInstance(new Object[]{1, 2}))).isNotNull();
    }

    @Test
    public void number_conversion() {
        StringPath strPath = Expressions.stringPath((String)"strPath");
        NumberPath intPath = Expressions.numberPath(Integer.class, (String)"intPath");
        QTuple qTuple = Projections.tuple((Expression[])new Expression[]{strPath, intPath});
        NumberConversions conversions = new NumberConversions((FactoryExpression)qTuple);
        Tuple tuple = (Tuple)conversions.newInstance(new Object[]{"a", 3L});
        Assertions.assertThat((String)((String)tuple.get((Expression)strPath))).isEqualTo("a");
        Assertions.assertThat((Integer)((Integer)tuple.get((Expression)intPath))).isEqualTo((Object)3);
    }

    public static enum Color {
        GREEN,
        BLUE,
        RED,
        YELLOW,
        BLACK,
        WHITE;

    }
}

