/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.support;

import com.querydsl.core.JoinExpression;
import com.querydsl.core.JoinType;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.support.OrderedQueryMetadata;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathMetadataFactory;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class OrderedQueryMetadataTest {
    private Path<Object> x = ExpressionUtils.path(Object.class, (PathMetadata)PathMetadataFactory.forVariable((String)"x"));
    private Path<Object> y = ExpressionUtils.path(Object.class, (PathMetadata)PathMetadataFactory.forVariable((String)"y"));
    private Path<Object> x_a = ExpressionUtils.path(Object.class, (PathMetadata)PathMetadataFactory.forProperty(this.x, (String)"a"));
    private Path<Object> x_a_a = ExpressionUtils.path(Object.class, (PathMetadata)PathMetadataFactory.forProperty(this.x_a, (String)"a"));
    private Path<Object> x_a_b = ExpressionUtils.path(Object.class, (PathMetadata)PathMetadataFactory.forProperty(this.x_a, (String)"b"));
    private Path<Object> x_b = ExpressionUtils.path(Object.class, (PathMetadata)PathMetadataFactory.forProperty(this.x, (String)"a"));
    private Path<Object> y_a = ExpressionUtils.path(Object.class, (PathMetadata)PathMetadataFactory.forProperty(this.y, (String)"a"));
    private Path<Object> y_b = ExpressionUtils.path(Object.class, (PathMetadata)PathMetadataFactory.forProperty(this.y, (String)"b"));

    private void addJoin(QueryMetadata md, JoinExpression j) {
        md.addJoin(j.getType(), j.getTarget());
    }

    @Test
    public void addJoin() {
        ArrayList<JoinExpression> joins = new ArrayList<JoinExpression>();
        joins.add(new JoinExpression(JoinType.DEFAULT, this.x));
        joins.add(new JoinExpression(JoinType.DEFAULT, this.y));
        joins.add(new JoinExpression(JoinType.INNERJOIN, this.y));
        joins.add(new JoinExpression(JoinType.INNERJOIN, this.x_a));
        joins.add(new JoinExpression(JoinType.INNERJOIN, this.x_a_a));
        joins.add(new JoinExpression(JoinType.INNERJOIN, this.x_a_b));
        joins.add(new JoinExpression(JoinType.INNERJOIN, this.x_b));
        joins.add(new JoinExpression(JoinType.INNERJOIN, this.y_a));
        joins.add(new JoinExpression(JoinType.INNERJOIN, this.y_b));
        for (JoinExpression join1 : joins) {
            for (JoinExpression join2 : joins) {
                OrderedQueryMetadata md = new OrderedQueryMetadata();
                this.addJoin((QueryMetadata)md, join1);
                this.addJoin((QueryMetadata)md, join2);
                this.validate(md.getJoins());
                for (JoinExpression join3 : joins) {
                    md = new OrderedQueryMetadata();
                    this.addJoin((QueryMetadata)md, join1);
                    this.addJoin((QueryMetadata)md, join2);
                    this.addJoin((QueryMetadata)md, join3);
                    this.validate(md.getJoins());
                    for (JoinExpression join4 : joins) {
                        md = new OrderedQueryMetadata();
                        this.addJoin((QueryMetadata)md, join1);
                        this.addJoin((QueryMetadata)md, join2);
                        this.addJoin((QueryMetadata)md, join3);
                        this.addJoin((QueryMetadata)md, join4);
                        this.validate(md.getJoins());
                    }
                }
            }
        }
    }

    private void validate(List<JoinExpression> joins) {
        int maxFromIndex = -1;
        int maxJoinIndex = -1;
        for (int i = 0; i < joins.size(); ++i) {
            if (joins.get(i).getType() == JoinType.DEFAULT) {
                maxFromIndex = i;
                continue;
            }
            maxJoinIndex = i;
        }
        String str = joins.toString();
        if (maxJoinIndex > -1 && maxFromIndex > -1) {
            ((AbstractBooleanAssert)Assertions.assertThat((maxJoinIndex >= maxFromIndex ? 1 : 0) != 0).as(str, new Object[0])).isTrue();
        }
    }
}

