/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.testutil.Serialization;
import com.querydsl.core.testutil.ThreadSafety;
import com.querydsl.core.types.Concatenation;
import com.querydsl.core.types.Constant;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.FactoryExpressionUtils;
import com.querydsl.core.types.ProjectionExample;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringPath;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ConstructorExpressionTest {
    StringPath str1 = Expressions.stringPath((String)"str1");
    StringPath str2 = Expressions.stringPath((String)"str2");
    StringPath str3 = Expressions.stringPath((String)"str3");
    Concatenation concat = new Concatenation(new Expression[]{this.str1, this.str2});

    @Test
    public void constructor() {
        Constant longVal = ConstantImpl.create((long)1L);
        Constant stringVal = ConstantImpl.create((Object)"");
        ProjectionExample instance = (ProjectionExample)new ConstructorExpression(ProjectionExample.class, new Class[]{Long.TYPE, String.class}, new Expression[]{longVal, stringVal}).newInstance(new Object[]{0L, ""});
        Assertions.assertThat((Object)instance).isNotNull();
        Assertions.assertThat((Long)instance.id).isEqualTo((Object)0L);
        Assertions.assertThat((String)instance.text).isEmpty();
    }

    @Test
    public void create() {
        Constant longVal = ConstantImpl.create((long)1L);
        Constant stringVal = ConstantImpl.create((Object)"");
        Assertions.assertThat((Object)((ProjectionExample)Projections.constructor(ProjectionExample.class, (Expression[])new Expression[]{longVal, stringVal}).newInstance(new Object[]{0L, ""}))).isNotNull();
    }

    @Test
    public void create2() {
        Constant longVal = ConstantImpl.create((long)1L);
        Assertions.assertThat((Object)((ProjectionExample)Projections.constructor(ProjectionExample.class, (Expression[])new Expression[]{longVal}).newInstance(new Object[]{0L}))).isNotNull();
    }

    @Test
    public void create3() {
        Assertions.assertThat((Object)((ProjectionExample)Projections.constructor(ProjectionExample.class, (Expression[])new Expression[0]).newInstance(new Object[0]))).isNotNull();
    }

    @Test
    public void create4() {
        Constant stringVal = ConstantImpl.create((Object)"");
        Assertions.assertThat((Object)((ProjectionExample)Projections.constructor(ProjectionExample.class, (Expression[])new Expression[]{stringVal}).newInstance(new Object[]{""}))).isNotNull();
    }

    @Test
    public void createNullPrimitive() {
        Constant booleanVal = ConstantImpl.create((boolean)false);
        Constant byteVal = ConstantImpl.create((byte)0);
        Constant charVal = ConstantImpl.create((char)'\u0000');
        Constant shortVal = ConstantImpl.create((short)0);
        Constant intVal = ConstantImpl.create((int)0);
        Constant longVal = ConstantImpl.create((long)0L);
        Constant floatVal = ConstantImpl.create((Object)Float.valueOf(0.0f));
        Constant doubleVal = ConstantImpl.create((Object)0.0);
        ProjectionExample instance = (ProjectionExample)Projections.constructor(ProjectionExample.class, (Expression[])new Expression[]{booleanVal, byteVal, charVal, shortVal, intVal, longVal, floatVal, doubleVal}).newInstance(new Object[]{null, null, null, null, null, null, null, null});
        Assertions.assertThat((Object)instance).isNotNull();
    }

    @Test
    public void factoryExpression_has_right_args() {
        ConstructorExpression constructor = Projections.constructor(ProjectionExample.class, (Expression[])new Expression[]{this.concat});
        constructor = FactoryExpressionUtils.wrap((FactoryExpression)constructor);
        Assertions.assertThat((List)constructor.getArgs()).isEqualTo(Arrays.asList(this.str1, this.str2));
    }

    @Test
    public void factoryExpression_newInstance() {
        ConstructorExpression constructor = Projections.constructor(ProjectionExample.class, (Expression[])new Expression[]{this.concat});
        constructor = FactoryExpressionUtils.wrap((FactoryExpression)constructor);
        ProjectionExample projection = (ProjectionExample)constructor.newInstance(new Object[]{"12", "34"});
        Assertions.assertThat((String)projection.text).isEqualTo("1234");
    }

    @Test
    public void serializability() {
        ConstructorExpression expr = Serialization.serialize(Projections.constructor(String.class, (Expression[])new Expression[0]));
        Assertions.assertThat((String)((String)expr.newInstance(new Object[0]))).isEqualTo("");
    }

    @Test
    public void threadSafety() {
        final ConstructorExpression expr = Projections.constructor(String.class, (Expression[])new Expression[0]);
        Runnable invoker = new Runnable(){

            @Override
            public void run() {
                expr.newInstance(new Object[0]);
            }
        };
        ThreadSafety.check(invoker, invoker);
    }
}

