/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.FactoryExpressionUtils;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.QTuple;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringPath;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DeepPopulationTest {
    @Test
    public void deep_population_via_qBean() {
        StringPath name = Expressions.stringPath((String)"name");
        StringPath id = Expressions.stringPath((String)"id");
        QBean entity2Bean = new QBean(Entity2.class, new Expression[]{name, id});
        QBean entity1Bean = new QBean(Entity1.class, Collections.singletonMap("entity2", entity2Bean));
        Entity1 entity1 = (Entity1)FactoryExpressionUtils.wrap((FactoryExpression)entity1Bean).newInstance(new Object[]{"nameX", "idX"});
        Assertions.assertThat((String)entity1.getEntity2().getName()).isEqualTo("nameX");
        Assertions.assertThat((String)entity1.getEntity2().getId()).isEqualTo("idX");
    }

    @Test
    public void deep_population_via_qTuple() {
        StringPath name = Expressions.stringPath((String)"name");
        StringPath id = Expressions.stringPath((String)"id");
        QBean entity2Bean = new QBean(Entity2.class, new Expression[]{name, id});
        QTuple tupleExpr = new QTuple(new Expression[]{entity2Bean});
        Tuple tuple = (Tuple)FactoryExpressionUtils.wrap((FactoryExpression)tupleExpr).newInstance(new Object[]{"nameX", "idX"});
        Assertions.assertThat((String)((Entity2)tuple.get((Expression)entity2Bean)).getName()).isEqualTo("nameX");
        Assertions.assertThat((String)((Entity2)tuple.get((Expression)entity2Bean)).getId()).isEqualTo("idX");
    }

    public static class Entity2 {
        private String name;
        private String id;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class Entity1 {
        private Entity2 entity2;

        public Entity2 getEntity2() {
            return this.entity2;
        }

        public void setEntity2(Entity2 entity2) {
            this.entity2 = entity2;
        }
    }
}

