/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.QueryException;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.SubQueryExpressionImpl;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringPath;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Ignore;
import org.junit.Test;

public class ExpressionUtilsTest {
    private static final StringPath str = Expressions.stringPath((String)"str");
    private static final StringPath str2 = Expressions.stringPath((String)"str2");

    @Test
    public void likeToRegex() {
        Assertions.assertThat((String)this.regex((Expression<String>)ConstantImpl.create((Object)"%"))).isEqualTo(".*");
        Assertions.assertThat((String)this.regex((Expression<String>)ConstantImpl.create((Object)"abc%"))).isEqualTo("^abc.*");
        Assertions.assertThat((String)this.regex((Expression<String>)ConstantImpl.create((Object)"%abc"))).isEqualTo(".*abc$");
        Assertions.assertThat((String)this.regex((Expression<String>)ConstantImpl.create((Object)"_"))).isEqualTo("^.$");
        StringPath path = Expressions.stringPath((String)"path");
        Assertions.assertThat((String)this.regex((Expression<String>)path.append("%"))).isEqualTo("path + .*");
        Assertions.assertThat((String)this.regex((Expression<String>)path.prepend("%"))).isEqualTo(".* + path");
        Assertions.assertThat((String)this.regex((Expression<String>)path.append("_"))).isEqualTo("path + .");
        Assertions.assertThat((String)this.regex((Expression<String>)path.prepend("_"))).isEqualTo(". + path");
    }

    @Test
    @Ignore
    public void likeToRegexSpeed() {
        StringPath path = Expressions.stringPath((String)"path");
        int iterations = 1000000;
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            this.regex((Expression<String>)ConstantImpl.create((Object)"%"));
            this.regex((Expression<String>)ConstantImpl.create((Object)"abc%"));
            this.regex((Expression<String>)ConstantImpl.create((Object)"%abc"));
            this.regex((Expression<String>)ConstantImpl.create((Object)"_"));
            this.regex((Expression<String>)path.append("%"));
            this.regex((Expression<String>)path.prepend("%"));
            this.regex((Expression<String>)path.append("_"));
            this.regex((Expression<String>)path.prepend("_"));
        }
        long duration = System.currentTimeMillis() - start;
        System.err.println(duration);
    }

    @Test
    public void likeToRegex_escape() {
        Assertions.assertThat((String)this.regex((Expression<String>)ConstantImpl.create((Object)"."))).isEqualTo("^\\.$");
    }

    @Test
    public void regexToLike() {
        Assertions.assertThat((String)this.like((Expression<String>)ConstantImpl.create((Object)".*"))).isEqualTo("%");
        Assertions.assertThat((String)this.like((Expression<String>)ConstantImpl.create((Object)"."))).isEqualTo("_");
        Assertions.assertThat((String)this.like((Expression<String>)ConstantImpl.create((Object)"\\."))).isEqualTo(".");
        StringPath path = Expressions.stringPath((String)"path");
        Assertions.assertThat((String)this.like((Expression<String>)path.append(".*"))).isEqualTo("path + %");
        Assertions.assertThat((String)this.like((Expression<String>)path.prepend(".*"))).isEqualTo("% + path");
        Assertions.assertThat((String)this.like((Expression<String>)path.append("."))).isEqualTo("path + _");
        Assertions.assertThat((String)this.like((Expression<String>)path.prepend("."))).isEqualTo("_ + path");
    }

    @Test(expected=QueryException.class)
    public void regexToLike_fail() {
        this.like((Expression<String>)ConstantImpl.create((Object)"a*"));
    }

    @Test(expected=QueryException.class)
    public void regexToLike_fail2() {
        this.like((Expression<String>)ConstantImpl.create((Object)"\\d"));
    }

    @Test(expected=QueryException.class)
    public void regexToLike_fail3() {
        this.like((Expression<String>)ConstantImpl.create((Object)"[ab]"));
    }

    @Test
    @Ignore
    public void regexToLikeSpeed() {
        StringPath path = Expressions.stringPath((String)"path");
        int iterations = 1000000;
        long start = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            this.like((Expression<String>)ConstantImpl.create((Object)".*"));
            this.like((Expression<String>)ConstantImpl.create((Object)"."));
            this.like((Expression<String>)path.append(".*"));
            this.like((Expression<String>)path.prepend(".*"));
            this.like((Expression<String>)path.append("."));
            this.like((Expression<String>)path.prepend("."));
        }
        long duration = System.currentTimeMillis() - start;
        System.err.println(duration);
    }

    private String regex(Expression<String> expr) {
        return ExpressionUtils.likeToRegex(expr).toString();
    }

    private String like(Expression<String> expr) {
        return ExpressionUtils.regexToLike(expr).toString();
    }

    @Test
    public void count() {
        Assertions.assertThat((String)ExpressionUtils.count((Expression)str).toString()).isEqualTo("count(str)");
    }

    @Test
    public void eqConst() {
        Assertions.assertThat((String)ExpressionUtils.eqConst((Expression)str, (Object)"X").toString()).isEqualTo("str = X");
    }

    @Test
    public void eq() {
        Assertions.assertThat((String)ExpressionUtils.eq((Expression)str, (Expression)str2).toString()).isEqualTo("str = str2");
    }

    @Test
    public void in() {
        Assertions.assertThat((String)ExpressionUtils.in((Expression)str, Arrays.asList("a", "b", "c")).toString()).isEqualTo("str in [a, b, c]");
    }

    @Test
    public void in_subQuery() {
        String s = ExpressionUtils.in((Expression)str, (SubQueryExpression)new SubQueryExpressionImpl(String.class, (QueryMetadata)new DefaultQueryMetadata())).toString();
        Assertions.assertThat((String)s).startsWith((CharSequence)"str in com.querydsl.core.DefaultQueryMetadata@c");
    }

    @Test
    public void inAny() {
        List<List> of = Arrays.asList(Arrays.asList("a", "b", "c"), Arrays.asList("d", "e", "f"));
        Assertions.assertThat((String)ExpressionUtils.inAny((Expression)str, of).toString()).isEqualTo("str in [a, b, c] || str in [d, e, f]");
    }

    @Test
    public void isNull() {
        Assertions.assertThat((String)ExpressionUtils.isNull((Expression)str).toString()).isEqualTo("str is null");
    }

    @Test
    public void isNotNull() {
        Assertions.assertThat((String)ExpressionUtils.isNotNull((Expression)str).toString()).isEqualTo("str is not null");
    }

    @Test
    public void neConst() {
        Assertions.assertThat((String)ExpressionUtils.neConst((Expression)str, (Object)"X").toString()).isEqualTo("str != X");
    }

    @Test
    public void ne() {
        Assertions.assertThat((String)ExpressionUtils.ne((Expression)str, (Expression)str2).toString()).isEqualTo("str != str2");
    }

    @Test
    public void notInAny() {
        List<List> of = Arrays.asList(Arrays.asList("a", "b", "c"), Arrays.asList("d", "e", "f"));
        Assertions.assertThat((String)ExpressionUtils.notInAny((Expression)str, of).toString()).isEqualTo("str not in [a, b, c] && str not in [d, e, f]");
    }

    @Test
    public void notIn_subQuery() {
        String s = ExpressionUtils.notIn((Expression)str, (SubQueryExpression)new SubQueryExpressionImpl(String.class, (QueryMetadata)new DefaultQueryMetadata())).toString();
        Assertions.assertThat((String)s).startsWith((CharSequence)"str not in com.querydsl.core.DefaultQueryMetadata@c");
    }
}

