/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.types.JavaTemplates;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Templates;
import com.querydsl.core.types.TemplatesTestUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class JavaTemplatesTest {
    private Templates templates = JavaTemplates.DEFAULT;

    @Test
    public void precedence() {
        int p1 = this.getPrecedence(new Operator[]{Ops.NOT});
        int p2 = this.getPrecedence(new Operator[]{Ops.MULT, Ops.DIV, Ops.MOD});
        int p3 = this.getPrecedence(new Operator[]{Ops.ADD, Ops.SUB});
        int p4 = this.getPrecedence(new Operator[]{Ops.LT, Ops.GT, Ops.GOE, Ops.LOE, Ops.BETWEEN, Ops.INSTANCE_OF});
        int p5 = this.getPrecedence(new Operator[]{Ops.EQ, Ops.NE});
        int p6 = this.getPrecedence(new Operator[]{Ops.AND});
        int p7 = this.getPrecedence(new Operator[]{Ops.OR});
        Assertions.assertThat((p1 < p2 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((p2 < p3 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((p3 < p4 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((p4 < p5 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((p5 < p6 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((p6 < p7 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void generic_precedence() {
        TemplatesTestUtils.testPrecedence((Templates)JavaTemplates.DEFAULT);
    }

    protected int getPrecedence(Operator ... ops) {
        int precedence = this.templates.getPrecedence(ops[0]);
        for (int i = 1; i < ops.length; ++i) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)this.templates.getPrecedence(ops[i])).as(ops[i].name(), new Object[0])).isEqualTo(precedence);
        }
        return precedence;
    }
}

