/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.types.Concatenation;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.FactoryExpressionUtils;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringPath;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class NestedExpressionTest {
    StringPath str1 = Expressions.stringPath((String)"str1");
    StringPath str2 = Expressions.stringPath((String)"str2");
    StringPath str3 = Expressions.stringPath((String)"str3");
    StringPath str4 = Expressions.stringPath((String)"str3");
    Concatenation concat1 = new Concatenation(new Expression[]{new Concatenation(new Expression[]{this.str1, this.str2}), this.str3});
    Concatenation concat2 = new Concatenation(new Expression[]{new Concatenation(new Expression[]{this.str1, new Concatenation(new Expression[]{this.str2, this.str3})}), this.str4});

    @Test
    public void wrapped_projection_has_right_arguments() {
        FactoryExpression wrapped = FactoryExpressionUtils.wrap((FactoryExpression)this.concat1);
        Assertions.assertThat((List)wrapped.getArgs()).isEqualTo(Arrays.asList(this.str1, this.str2, this.str3));
    }

    @Test
    public void wrapped_projection_compresses_projection() {
        FactoryExpression wrapped = FactoryExpressionUtils.wrap((FactoryExpression)this.concat1);
        Assertions.assertThat((String)((String)wrapped.newInstance(new Object[]{"1", "2", "3"}))).isEqualTo("123");
    }

    @Test
    public void deeply_wrapped_projection_has_right_arguments() {
        FactoryExpression wrapped = FactoryExpressionUtils.wrap((FactoryExpression)this.concat2);
        Assertions.assertThat((List)wrapped.getArgs()).isEqualTo(Arrays.asList(this.str1, this.str2, this.str3, this.str4));
    }

    @Test
    public void deeply_wrapped_projection_compresses_projection() {
        FactoryExpression wrapped = FactoryExpressionUtils.wrap((FactoryExpression)this.concat2);
        Assertions.assertThat((String)((String)wrapped.newInstance(new Object[]{"1", "2", "3", "4"}))).isEqualTo("1234");
    }
}

