/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.Concatenation;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.FactoryExpressionUtils;
import com.querydsl.core.types.QTuple;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.StringPath;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Ignore;
import org.junit.Test;

public class QTupleTest {
    StringPath str1 = Expressions.stringPath((String)"str1");
    StringPath str2 = Expressions.stringPath((String)"str2");
    StringPath str3 = Expressions.stringPath((String)"str3");
    StringPath str4 = Expressions.stringPath((String)"str4");
    Expression<?>[] exprs1 = new Expression[]{this.str1, this.str2};
    Expression<?>[] exprs2 = new Expression[]{this.str3, this.str4};
    Concatenation concat = new Concatenation(new Expression[]{this.str1, this.str2});

    @Test
    public void alias() {
        StringExpression expr = this.str1.as("s");
        QTuple qTuple = new QTuple(new Expression[]{expr});
        Tuple tuple = qTuple.newInstance(new Object[]{"arg"});
        org.junit.jupiter.api.Assertions.assertEquals((Object)"arg", (Object)tuple.get((Expression)expr));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"arg", (Object)tuple.get((Expression)Expressions.stringPath((String)"s")));
    }

    @Test
    public void twoExpressions_getArgs() {
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(this.str1, this.str2), (Object)new QTuple(new Expression[]{this.str1, this.str2}).getArgs());
    }

    @Test
    public void oneArray_getArgs() {
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(this.str1, this.str2), (Object)new QTuple(this.exprs1).getArgs());
    }

    @Test
    public void twoExpressionArrays_getArgs() {
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(this.str1, this.str2, this.str3, this.str4), (Object)new QTuple((Expression[][])new Expression[][]{this.exprs1, this.exprs2}).getArgs());
    }

    @Test
    public void nestedProjection_getArgs() {
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(this.str1, this.str2), (Object)FactoryExpressionUtils.wrap((FactoryExpression)new QTuple(new Expression[]{this.concat})).getArgs());
    }

    @Test
    public void nestedProjection_getArgs2() {
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(this.str1, this.str2, this.str3), (Object)FactoryExpressionUtils.wrap((FactoryExpression)new QTuple(new Expression[]{this.concat, this.str3})).getArgs());
    }

    @Test
    public void nestedProjection_newInstance() {
        QTuple expr = new QTuple(new Expression[]{this.concat});
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1234", (Object)((Tuple)FactoryExpressionUtils.wrap((FactoryExpression)expr).newInstance(new Object[]{"12", "34"})).get((Expression)this.concat));
    }

    @Test
    public void nestedProjection_newInstance2() {
        QTuple expr = new QTuple(new Expression[]{this.str1, this.str2, this.concat});
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1234", (Object)((Tuple)FactoryExpressionUtils.wrap((FactoryExpression)expr).newInstance(new Object[]{"1", "2", "12", "34"})).get((Expression)this.concat));
    }

    @Test
    public void tuple_equals() {
        QTuple expr = new QTuple(new Expression[]{this.str1, this.str2});
        org.junit.jupiter.api.Assertions.assertEquals((Object)expr.newInstance(new Object[]{"str1", "str2"}), (Object)expr.newInstance(new Object[]{"str1", "str2"}));
    }

    @Test
    public void tuple_hashCode() {
        QTuple expr = new QTuple(new Expression[]{this.str1, this.str2});
        org.junit.jupiter.api.Assertions.assertEquals((int)expr.newInstance(new Object[]{"str1", "str2"}).hashCode(), (int)expr.newInstance(new Object[]{"str1", "str2"}).hashCode());
    }

    @Test
    @Ignore
    public void duplicates() {
        QTuple expr = new QTuple(new Expression[]{this.str1, this.str1});
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)expr.getArgs().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.str1, expr.getArgs().get(0));
    }

    @Test
    @Ignore
    public void duplicates2() {
        QTuple expr = new QTuple(Arrays.asList(this.str1, this.str1));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)expr.getArgs().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.str1, expr.getArgs().get(0));
    }

    @Test
    public void newInstance() {
        Assertions.assertThat((Object)new QTuple(new Expression[]{this.str1, this.str1}).newInstance(new Object[]{null, null})).isNotNull();
        Assertions.assertThat((Object)((Tuple)new QTuple(new Expression[]{this.str1, this.str1}).skipNulls().newInstance(new Object[]{null, null}))).isNull();
    }
}

