/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.Coalesce;
import com.querydsl.core.types.dsl.DslExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class SignatureTest {
    private List<Class<?>> classes = new ArrayList();

    @Before
    public void setUp() throws ClassNotFoundException {
        for (String folder : Collections.singletonList("com/querydsl/core/types/dsl")) {
            for (String file : new File("src/main/java", folder).list()) {
                if (!file.endsWith(".java") || file.equals("package-info.java")) continue;
                String className = (folder + "." + file.substring(0, file.length() - 5)).replace('/', '.');
                this.classes.add(Class.forName(className));
            }
        }
    }

    @Test
    public void returnType_extends_simpleExpression() {
        Assertions.assertThat(this.classes).isNotEmpty();
        HashSet<String> skippedMethods = new HashSet<String>(Arrays.asList("getArg", "getRoot", "not"));
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        for (Class<?> clazz : this.classes) {
            if (clazz.equals(Expressions.class)) continue;
            for (Method m : clazz.getDeclaredMethods()) {
                if (skippedMethods.contains(m.getName()) || !Modifier.isPublic(m.getModifiers()) || !Expression.class.isAssignableFrom(m.getReturnType()) || Coalesce.class.isAssignableFrom(m.getReturnType()) || DslExpression.class.isAssignableFrom(m.getReturnType()) || SimpleExpression.class.isAssignableFrom(m.getReturnType())) continue;
                errors.add((CallSite)((Object)(clazz.getSimpleName() + "." + m.getName() + " has illegal return type")));
            }
        }
        for (String string : errors) {
            System.err.println(string);
        }
        if (!errors.isEmpty()) {
            Assertions.fail((String)"", (Object[])new Object[]{"Got " + errors.size() + " errors"});
        }
    }
}

