/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.alias.Alias;
import com.querydsl.core.types.ArrayConstructorExpression;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Templates;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class StringTest {
    @Test
    public void patternAvailability() throws IllegalArgumentException, IllegalAccessException {
        DummyTemplates ops = new DummyTemplates();
        HashSet<Field> missing = new HashSet<Field>();
        for (Field field : Ops.class.getFields()) {
            Operator op;
            if (!field.getType().equals(Operator.class) || ops.getTemplate(op = (Operator)field.get(null)) != null) continue;
            missing.add(field);
        }
        for (AnnotatedElement annotatedElement : Ops.class.getClasses()) {
            for (Field field : ((Class)annotatedElement).getFields()) {
                Operator op;
                if (!field.getType().equals(Operator.class) || ops.getTemplate(op = (Operator)field.get(null)) != null) continue;
                missing.add(field);
            }
        }
        if (!missing.isEmpty()) {
            for (Field field : missing) {
                System.err.println(field.getName());
            }
            Assertions.fail((String)"");
        }
    }

    @Test
    public void toString_() {
        SomeType alias = (SomeType)Alias.alias(SomeType.class, (String)"alias");
        Assertions.assertThat((String)Alias.$((String)alias.getName()).toString()).isEqualTo("alias.name");
        Assertions.assertThat((String)Alias.$((String)alias.getRef().getName()).toString()).isEqualTo("alias.ref.name");
        Assertions.assertThat((String)Alias.$((Object)alias.getRefs().get(0)).toString()).isEqualTo("alias.refs.get(0)");
        Assertions.assertThat((String)Alias.$((String)alias.getName()).lower().toString()).isEqualTo("lower(alias.name)");
        ConstructorExpression someType = new ConstructorExpression(SomeType.class, new Class[]{SomeType.class}, new Expression[]{Alias.$((Object)alias)});
        Assertions.assertThat((String)someType.toString()).isEqualTo("new SomeType(alias)");
        ArrayConstructorExpression someTypeArray = new ArrayConstructorExpression(SomeType[].class, new Expression[]{Alias.$((Object)alias)});
        Assertions.assertThat((String)someTypeArray.toString()).isEqualTo("new SomeType[](alias)");
    }

    private static class DummyTemplates
    extends Templates {
        private DummyTemplates() {
        }
    }

    public static class SomeType {
        public SomeType() {
        }

        public SomeType(SomeType st) {
        }

        public String getName() {
            return "";
        }

        public SomeType getRef() {
            return null;
        }

        public List<SomeType> getRefs() {
            return null;
        }

        public int getAmount() {
            return 0;
        }
    }
}

