/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.types.Template;
import com.querydsl.core.types.TemplateFactory;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TemplateTest {
    @Test
    public void test() {
        TemplateFactory factory = new TemplateFactory('\\');
        this.match("[0, ' + ', 1, ' + ', 2]", factory.create("{0} + {1} + {2}"));
        this.match("['blah ', 0, ' + ', 1, ' + ', 2, ' XXX']", factory.create("blah {0} + {1} + {2} XXX"));
        this.match("['+', 1]", factory.create("+{1}"));
        this.match("[1, '.method()']", factory.create("{1}.method()"));
        this.match("[0, '.get(', 1, ')']", factory.create("{0}.get({1})"));
        this.match("[0, '.', 1s]", factory.create("{0}.{1s}"));
    }

    @Test
    public void operation() {
        TemplateFactory factory = new TemplateFactory('\\');
        this.match("[0 ADD 1]", factory.create("{0+1}"));
        this.match("[0 DIV 1]", factory.create("{0/1}"));
    }

    @Test
    public void operationConst() {
        TemplateFactory factory = new TemplateFactory('\\');
        this.match("[0 ADD 1]", factory.create("{0+'1'}"));
        this.match("[0 DIV 1.0]", factory.create("{0/'1.0'}"));
        this.match("[0 MULT 3.141592653589793, ' / 180.0)']", factory.create("{0*'3.141592653589793'} / 180.0)"));
    }

    @Test
    public void like() {
        TemplateFactory factory = new TemplateFactory('\\');
        this.match("[0]", factory.create("{0%}"));
        this.match("[0]", factory.create("{%0}"));
        this.match("[0]", factory.create("{%0%}"));
        this.match("[0]", factory.create("{0%%}"));
        this.match("[0]", factory.create("{%%0}"));
        this.match("[0]", factory.create("{%%0%%}"));
    }

    private void match(String string, Template template) {
        Assertions.assertThat((String)template.getElements().toString()).isEqualTo(string);
    }
}

