/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Template;
import com.querydsl.core.types.Templates;
import org.assertj.core.api.Assertions;

public final class TemplatesTestUtils {
    public static void testPrecedence(Templates templates) {
        int likePrecedence = templates.getPrecedence((Operator)Ops.LIKE);
        int eqPrecedence = templates.getPrecedence((Operator)Ops.EQ);
        if (templates.getPrecedence((Operator)Ops.EQ_IGNORE_CASE) != eqPrecedence) {
            Assertions.fail((String)"", (Object[])new Object[]{"Unexpected precedence for EQ_IGNORE_CASE " + templates.getPrecedence((Operator)Ops.EQ_IGNORE_CASE)});
        }
        for (Ops op : Ops.values()) {
            Template template = templates.getTemplate((Operator)op);
            String str = template.toString();
            int precedence = templates.getPrecedence((Operator)op);
            if (str.contains(" like ") && precedence != likePrecedence) {
                Assertions.fail((String)"", (Object[])new Object[]{"Unexpected precedence for " + String.valueOf(op) + " with template " + String.valueOf(template)});
                continue;
            }
            if (!str.contains("(") && !str.contains(".") && precedence < 0) {
                Assertions.fail((String)"", (Object[])new Object[]{"Unexpected precedence for " + String.valueOf(op) + " with template " + String.valueOf(template)});
                continue;
            }
            if (str.matches(".*[<>] ?\\-?\\d")) {
                if (precedence == 50) continue;
                Assertions.fail((String)"", (Object[])new Object[]{"Unsafe pattern for " + String.valueOf(op) + " with template " + String.valueOf(template)});
                continue;
            }
            if (!str.matches(".*[\\+\\-] ?\\-?\\d") || precedence == 40 || precedence == 30) continue;
            Assertions.fail((String)"", (Object[])new Object[]{"Unsafe pattern for " + String.valueOf(op) + " with template " + String.valueOf(template)});
        }
    }

    private TemplatesTestUtils() {
    }
}

