/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.domain.QCat;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.PathType;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.TemplateExpression;
import com.querydsl.core.types.Templates;
import com.querydsl.core.types.ToStringVisitor;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.Expressions;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ToStringVisitorTest {
    private Templates templates = new Templates(this){
        {
            this.add((Operator)PathType.PROPERTY, "{0}_{1}");
            this.add((Operator)PathType.COLLECTION_ANY, "{0}");
        }
    };

    @Test
    public void operation() {
        Assertions.assertThat((String)((String)QCat.cat.name.isNotNull().accept((Visitor)ToStringVisitor.DEFAULT, (Object)this.templates))).isEqualTo("cat_name is not null");
    }

    @Test
    public void template() {
        TemplateExpression template = ExpressionUtils.template(Boolean.class, (String)"{0} is not null", (Object[])new Object[]{QCat.cat.name});
        Assertions.assertThat((String)((String)template.accept((Visitor)ToStringVisitor.DEFAULT, (Object)this.templates))).isEqualTo("cat_name is not null");
    }

    @Test
    public void path() {
        Assertions.assertThat((String)((String)((QCat)((QCat)QCat.cat.kittens.any()).kittens.any()).name.accept((Visitor)ToStringVisitor.DEFAULT, (Object)this.templates))).isEqualTo("cat_kittens_kittens_name");
    }

    @Test
    public void complex() {
        BooleanPath a = Expressions.booleanPath((String)"a");
        BooleanPath b = Expressions.booleanPath((String)"d");
        BooleanPath c = Expressions.booleanPath((String)"c");
        BooleanPath d = Expressions.booleanPath((String)"d");
        BooleanExpression complex = a.or((Predicate)b).and((Predicate)c.or((Predicate)d));
        Assertions.assertThat((String)((String)complex.accept((Visitor)ToStringVisitor.DEFAULT, (Object)this.templates))).isEqualTo("(a || d) && (c || d)");
    }
}

