/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.annotations.PropertyType;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathMetadataFactory;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BeanPath;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.PathInits;
import com.querydsl.core.types.dsl.SimplePath;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.Nullable;
import org.junit.Ignore;
import org.junit.Test;

public class BeanPathTest {
    private BeanPath<BeanPathTest> beanPath = new BeanPath(BeanPathTest.class, "p");

    @Test
    public void as_path() {
        SimplePath simplePath = new SimplePath(BeanPathTest.class, "p");
        Assertions.assertThat((Object)this.beanPath.as((Path)simplePath)).isNotNull();
    }

    @Test
    @Ignore
    public void as_class() {
        MyBeanPath otherPath = (MyBeanPath)this.beanPath.as(MyBeanPath.class);
        Assertions.assertThat((Object)((Object)otherPath)).isEqualTo(this.beanPath);
        Assertions.assertThat((boolean)otherPath.getMetadata().isRoot()).isTrue();
    }

    @Test
    public void as_class_cached() {
        MyBeanPath otherPath = (MyBeanPath)this.beanPath.as(MyBeanPath.class);
        Assertions.assertThat((otherPath == this.beanPath.as(MyBeanPath.class) ? 1 : 0) != 0).isTrue();
    }

    @Test
    @Ignore
    public void as_class_with_inits() {
        this.beanPath = new BeanPath(BeanPathTest.class, PathMetadataFactory.forVariable((String)"p"), PathInits.DEFAULT);
        MyBeanPath otherPath = (MyBeanPath)this.beanPath.as(MyBeanPath.class);
        Assertions.assertThat((Object)((Object)otherPath)).isEqualTo(this.beanPath);
    }

    @Test
    public void as_class_with_inits_cached() {
        this.beanPath = new BeanPath(BeanPathTest.class, PathMetadataFactory.forVariable((String)"p"), PathInits.DEFAULT);
        MyBeanPath otherPath = (MyBeanPath)this.beanPath.as(MyBeanPath.class);
        Assertions.assertThat((otherPath == this.beanPath.as(MyBeanPath.class) ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void createEnum() {
        Assertions.assertThat((Object)this.beanPath.createEnum("property", PropertyType.class)).isNotNull();
    }

    @Test
    public void instanceOf() {
        Assertions.assertThat((Object)this.beanPath.instanceOf(BeanPathTest.class)).isNotNull();
    }

    @Test
    public void instanceOfAny() {
        BooleanExpression pred1 = this.beanPath.instanceOf(BeanPathTest.class).or((Predicate)this.beanPath.instanceOf(SubClass.class));
        BooleanExpression pred2 = this.beanPath.instanceOfAny(new Class[]{BeanPathTest.class, SubClass.class});
        Assertions.assertThat((Object)pred2).isEqualTo((Object)pred1);
        Assertions.assertThat((String)pred2.toString()).isEqualTo("p instanceof class com.querydsl.core.types.dsl.BeanPathTest || p instanceof class com.querydsl.core.types.dsl.BeanPathTest$SubClass");
    }

    public static class MyBeanPath
    extends BeanPath<BeanPathTest> {
        private static final long serialVersionUID = 6225684967115368814L;

        public MyBeanPath(PathMetadata metadata) {
            super(BeanPathTest.class, metadata);
        }

        public MyBeanPath(PathMetadata metadata, @Nullable PathInits inits) {
            super(BeanPathTest.class, metadata);
        }
    }

    public static class SubClass
    extends BeanPathTest {
    }
}

