/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.Expressions;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class BooleanExpressionTest {
    private final BooleanExpression a = new BooleanPath("a");
    private final BooleanExpression b = new BooleanPath("b");
    private final BooleanExpression c = new BooleanPath("c");

    @Test
    public void anyOf() {
        Assertions.assertThat((Object)Expressions.anyOf((BooleanExpression[])new BooleanExpression[]{this.a, this.b, this.c})).isEqualTo((Object)this.a.or((Predicate)this.b).or((Predicate)this.c));
    }

    @Test
    public void allOf() {
        Assertions.assertThat((Object)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{this.a, this.b, this.c})).isEqualTo((Object)this.a.and((Predicate)this.b).and((Predicate)this.c));
    }

    @Test
    public void allOf_with_nulls() {
        Assertions.assertThat((String)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{this.a, this.b, null}).toString()).isEqualTo("a && b");
        Assertions.assertThat((String)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{this.a, null}).toString()).isEqualTo("a");
        Assertions.assertThat((String)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{null, this.a}).toString()).isEqualTo("a");
    }

    @Test
    public void anyOf_with_nulls() {
        Assertions.assertThat((String)Expressions.anyOf((BooleanExpression[])new BooleanExpression[]{this.a, this.b, null}).toString()).isEqualTo("a || b");
        Assertions.assertThat((String)Expressions.anyOf((BooleanExpression[])new BooleanExpression[]{this.a, null}).toString()).isEqualTo("a");
        Assertions.assertThat((String)Expressions.anyOf((BooleanExpression[])new BooleanExpression[]{null, this.a}).toString()).isEqualTo("a");
    }

    @Test
    public void andAnyOf() {
        Assertions.assertThat((Object)this.a.andAnyOf(new Predicate[]{this.b, this.c})).isEqualTo((Object)this.a.and((Predicate)this.b.or((Predicate)this.c)));
    }

    @Test
    public void orAllOf() {
        Assertions.assertThat((Object)this.a.orAllOf(new Predicate[]{this.b, this.c})).isEqualTo((Object)this.a.or((Predicate)this.b.and((Predicate)this.c)));
    }

    @Test
    public void not() {
        Assertions.assertThat((Object)this.a.not().not()).isEqualTo((Object)this.a);
    }

    @Test
    public void isTrue() {
        Assertions.assertThat((Object)this.a.isTrue()).isEqualTo((Object)this.a.eq(Boolean.valueOf(true)));
    }

    @Test
    public void isFalse() {
        Assertions.assertThat((Object)this.a.isFalse()).isEqualTo((Object)this.a.eq(Boolean.valueOf(false)));
    }
}

