/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.alias.Alias;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.core.types.dsl.EnumExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class CaseBuilderTest {
    @Test
    public void general() {
        SimpleExpression expr = (SimpleExpression)new CaseBuilder().when((Predicate)Expressions.TRUE).then(new Object()).otherwise(null);
        Assertions.assertThat((Object)expr).isNotNull();
    }

    @Test
    public void booleanTyped() {
        Customer c = (Customer)Alias.alias(Customer.class, (String)"customer");
        BooleanExpression cases = (BooleanExpression)new CaseBuilder().when((Predicate)Alias.$((Long)c.getAnnualSpending()).gt((Number)10000)).then(true).otherwise((Object)false);
        Assertions.assertThat((String)cases.toString()).isEqualTo("case when customer.annualSpending > 10000 then true else false end");
    }

    @Test
    public void booleanTyped_predicate() {
        Customer c = (Customer)Alias.alias(Customer.class, (String)"customer");
        BooleanExpression cases = (BooleanExpression)new CaseBuilder().when((Predicate)Alias.$((Long)c.getAnnualSpending()).gt((Number)20000)).then(false).when((Predicate)Alias.$((Long)c.getAnnualSpending()).gt((Number)10000)).then((Object)true).otherwise((Object)false);
        Assertions.assertThat((String)cases.toString()).isEqualTo("case when customer.annualSpending > 20000 then false when customer.annualSpending > 10000 then true else false end");
    }

    @Test
    public void enumTyped() {
        Customer c = (Customer)Alias.alias(Customer.class, (String)"customer");
        EnumExpression cases = (EnumExpression)new CaseBuilder().when((Predicate)Alias.$((Long)c.getAnnualSpending()).gt((Number)10000)).then((Enum)Gender.MALE).otherwise((Object)Gender.FEMALE);
        Assertions.assertThat((String)cases.toString()).isEqualTo("case when customer.annualSpending > 10000 then MALE else FEMALE end");
    }

    @Test
    public void numberTyped() {
        Customer c = (Customer)Alias.alias(Customer.class, (String)"customer");
        NumberExpression cases = (NumberExpression)new CaseBuilder().when((Predicate)Alias.$((Long)c.getAnnualSpending()).gt((Number)10000)).then((Number)1).when((Predicate)Alias.$((Long)c.getAnnualSpending()).gt((Number)5000)).then((Object)2).when((Predicate)Alias.$((Long)c.getAnnualSpending()).gt((Number)2000)).then((Object)3).otherwise((Object)4);
        Assertions.assertThat((String)cases.toString()).isEqualTo("case when customer.annualSpending > 10000 then 1 when customer.annualSpending > 5000 then 2 when customer.annualSpending > 2000 then 3 else 4 end");
    }

    @Test
    public void stringTyped() {
        Customer c = (Customer)Alias.alias(Customer.class, (String)"customer");
        StringExpression cases = (StringExpression)new CaseBuilder().when((Predicate)Alias.$((Long)c.getAnnualSpending()).gt((Number)10000)).then("Premier").when((Predicate)Alias.$((Long)c.getAnnualSpending()).gt((Number)5000)).then((Object)"Gold").when((Predicate)Alias.$((Long)c.getAnnualSpending()).gt((Number)2000)).then((Object)"Silver").otherwise((Object)"Bronze");
        Assertions.assertThat((String)cases.toString()).isEqualTo("case when customer.annualSpending > 10000 then Premier when customer.annualSpending > 5000 then Gold when customer.annualSpending > 2000 then Silver else Bronze end");
    }

    public static class Customer {
        private long annualSpending;

        public long getAnnualSpending() {
            return this.annualSpending;
        }
    }

    public static enum Gender {
        MALE,
        FEMALE;

    }
}

