/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.Coalesce;
import com.querydsl.core.types.dsl.StringPath;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class CoalesceTest {
    private final StringPath firstname = new StringPath("firstname");
    private final StringPath lastname = new StringPath("lastname");

    @Test
    public void mutable() {
        Coalesce c = new Coalesce(new Expression[]{this.firstname, this.lastname}).add((Comparable)((Object)"xxx"));
        Assertions.assertThat((String)c.toString()).isEqualTo("coalesce(firstname, lastname, xxx)");
        Assertions.assertThat((String)c.add((Comparable)((Object)"yyy")).toString()).isEqualTo("coalesce(firstname, lastname, xxx, yyy)");
    }

    @Test
    public void withList() {
        Coalesce c = new Coalesce(new Expression[]{this.firstname, this.lastname}).add((Comparable)((Object)"xxx"));
        Assertions.assertThat((String)c.toString()).isEqualTo("coalesce(firstname, lastname, xxx)");
    }

    @Test
    public void withSingleArg() {
        Coalesce c = new Coalesce(new Expression[0]).add((Comparable)((Object)"xxx"));
        Assertions.assertThat((String)c.toString()).isEqualTo("coalesce(xxx)");
    }

    @Test
    public void asComparable() {
        Coalesce c = new Coalesce(new Expression[]{this.firstname, this.lastname});
        c.getValue().asc();
    }

    @Test
    public void asString() {
        Coalesce c = new Coalesce(new Expression[]{this.firstname, this.lastname});
        c.asString().lower();
    }

    @Test
    public void withoutWarnings() {
        Coalesce c = new Coalesce(String.class, new Expression[0]).add((Expression)this.firstname).add((Expression)this.lastname);
        Assertions.assertThat((String)c.toString()).isEqualTo("coalesce(firstname, lastname)");
    }

    @Test
    public void dsl() {
        Assertions.assertThat((String)this.firstname.coalesce((Expression)this.lastname).toString()).isEqualTo("coalesce(firstname, lastname)");
    }

    @Test
    public void dsl2() {
        Assertions.assertThat((String)new Coalesce(new Expression[0]).add((Expression)this.firstname).add((Expression)this.lastname).add((Comparable)((Object)"xxx")).toString()).isEqualTo("coalesce(firstname, lastname, xxx)");
    }

    @Test
    public void dsl3() {
        Assertions.assertThat((String)this.firstname.coalesce("xxx").toString()).isEqualTo("coalesce(firstname, xxx)");
    }

    @Test
    public void asc() {
        Assertions.assertThat((String)this.firstname.coalesce("xxx").asc().toString()).isEqualTo("coalesce(firstname, xxx) ASC");
    }

    @Test
    public void desc() {
        Assertions.assertThat((String)this.firstname.coalesce("xxx").desc().toString()).isEqualTo("coalesce(firstname, xxx) DESC");
    }
}

