/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Template;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.util.BeanUtils;
import java.lang.reflect.Method;
import java.sql.Time;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ExpressionsTest {
    private static final StringPath str = new StringPath("str");
    private static final BooleanExpression a = new BooleanPath("a");
    private static final BooleanExpression b = new BooleanPath("b");
    private TimeZone timeZone = null;

    @Before
    public void setUp() {
        this.timeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    @After
    public void tearDown() {
        TimeZone.setDefault(this.timeZone);
    }

    @Test
    public void Signature() throws NoSuchMethodException {
        List<String> types = Arrays.asList("boolean", "comparable", "date", "dsl", "dateTime", "enum", "number", "simple", "string", "time");
        for (String type : types) {
            if (type.equals("boolean") || type.equals("string")) {
                this.assertReturnType(Expressions.class.getMethod(type + "Path", String.class));
                this.assertReturnType(Expressions.class.getMethod(type + "Path", Path.class, String.class));
                this.assertReturnType(Expressions.class.getMethod(type + "Path", PathMetadata.class));
                this.assertReturnType(Expressions.class.getMethod(type + "Operation", Operator.class, Expression[].class));
                this.assertReturnType(Expressions.class.getMethod(type + "Template", String.class, Object[].class));
                this.assertReturnType(Expressions.class.getMethod(type + "Template", String.class, List.class));
                this.assertReturnType(Expressions.class.getMethod(type + "Template", Template.class, Object[].class));
                this.assertReturnType(Expressions.class.getMethod(type + "Template", Template.class, List.class));
                continue;
            }
            this.assertReturnType(Expressions.class.getMethod(type + "Path", Class.class, String.class));
            this.assertReturnType(Expressions.class.getMethod(type + "Path", Class.class, Path.class, String.class));
            this.assertReturnType(Expressions.class.getMethod(type + "Path", Class.class, PathMetadata.class));
            this.assertReturnType(Expressions.class.getMethod(type + "Operation", Class.class, Operator.class, Expression[].class));
            this.assertReturnType(Expressions.class.getMethod(type + "Template", Class.class, String.class, Object[].class));
            this.assertReturnType(Expressions.class.getMethod(type + "Template", Class.class, String.class, List.class));
            this.assertReturnType(Expressions.class.getMethod(type + "Template", Class.class, Template.class, Object[].class));
            this.assertReturnType(Expressions.class.getMethod(type + "Template", Class.class, Template.class, List.class));
        }
        this.assertReturnType(Expressions.class.getMethod("arrayPath", Class.class, String.class));
        this.assertReturnType(Expressions.class.getMethod("arrayPath", Class.class, Path.class, String.class));
        this.assertReturnType(Expressions.class.getMethod("arrayPath", Class.class, PathMetadata.class));
    }

    private void assertReturnType(Method method) {
        Assertions.assertThat((String)method.getReturnType().getSimpleName()).isEqualTo(BeanUtils.capitalize((String)method.getName()));
    }

    @Test
    public void as() {
        Assertions.assertThat((String)Expressions.as(null, (Path)str).toString()).isEqualTo("null as str");
        Assertions.assertThat((String)Expressions.as((Expression)new StringPath("s"), (Path)str).toString()).isEqualTo("s as str");
    }

    @Test
    public void allOf() {
        Assertions.assertThat((String)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{a, b}).toString()).isEqualTo("a && b");
    }

    @Test
    public void allOf_with_nulls() {
        Assertions.assertThat((String)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{a, b, null}).toString()).isEqualTo("a && b");
        Assertions.assertThat((String)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{a, null}).toString()).isEqualTo("a");
        Assertions.assertThat((String)Expressions.allOf((BooleanExpression[])new BooleanExpression[]{null, a}).toString()).isEqualTo("a");
    }

    @Test
    public void anyOf() {
        Assertions.assertThat((String)Expressions.anyOf((BooleanExpression[])new BooleanExpression[]{a, b}).toString()).isEqualTo("a || b");
    }

    @Test
    public void anyOf_with_nulls() {
        Assertions.assertThat((String)Expressions.anyOf((BooleanExpression[])new BooleanExpression[]{a, b, null}).toString()).isEqualTo("a || b");
        Assertions.assertThat((String)Expressions.anyOf((BooleanExpression[])new BooleanExpression[]{a, null}).toString()).isEqualTo("a");
        Assertions.assertThat((String)Expressions.anyOf((BooleanExpression[])new BooleanExpression[]{null, a}).toString()).isEqualTo("a");
    }

    @Test
    public void constant() {
        Assertions.assertThat((String)Expressions.constant((Object)"X").toString()).isEqualTo("X");
    }

    @Test
    public void constant_as() {
        Assertions.assertThat((String)Expressions.constantAs((Object)"str", (Path)str).toString()).isEqualTo("str as str");
    }

    @Test
    public void template() {
        Assertions.assertThat((String)Expressions.template(Object.class, (String)"{0} && {1}", (Object[])new Object[]{a, b}).toString()).isEqualTo("a && b");
    }

    @Test
    public void comparableTemplate() {
        Assertions.assertThat((String)Expressions.comparableTemplate(Boolean.class, (String)"{0} && {1}", (Object[])new Object[]{a, b}).toString()).isEqualTo("a && b");
    }

    @Test
    public void numberTemplate() {
        Assertions.assertThat((String)Expressions.numberTemplate(Integer.class, (String)"1", (Object[])new Object[0]).toString()).isEqualTo("1");
    }

    @Test
    public void stringTemplate() {
        Assertions.assertThat((String)Expressions.stringTemplate((String)"X", (Object[])new Object[0]).toString()).isEqualTo("X");
    }

    @Test
    public void booleanTemplate() {
        Assertions.assertThat((String)Expressions.booleanTemplate((String)"{0} && {1}", (Object[])new Object[]{a, b}).toString()).isEqualTo("a && b");
    }

    @Test
    public void subQuery() {
    }

    @Test
    public void operation() {
        Assertions.assertThat((String)Expressions.operation(Boolean.class, (Operator)Ops.AND, (Expression[])new Expression[]{a, b}).toString()).isEqualTo("a && b");
    }

    @Test
    public void predicate() {
        Assertions.assertThat((String)Expressions.predicate((Operator)Ops.AND, (Expression[])new Expression[]{a, b}).toString()).isEqualTo("a && b");
    }

    @Test
    public void pathClassOfTString() {
        Assertions.assertThat((String)Expressions.path(String.class, (String)"variable").toString()).isEqualTo("variable");
    }

    @Test
    public void pathClassOfTPathOfQString() {
        Assertions.assertThat((String)Expressions.path(String.class, (Path)Expressions.path(Object.class, (String)"variable"), (String)"property").toString()).isEqualTo("variable.property");
    }

    @Test
    public void comparablePathClassOfTString() {
        Assertions.assertThat((String)Expressions.comparablePath(String.class, (String)"variable").toString()).isEqualTo("variable");
    }

    @Test
    public void comparablePathClassOfTPathOfQString() {
        Assertions.assertThat((String)Expressions.comparablePath(String.class, (Path)Expressions.path(Object.class, (String)"variable"), (String)"property").toString()).isEqualTo("variable.property");
    }

    @Test
    public void datePathClassOfTString() {
        Assertions.assertThat((String)Expressions.datePath(Date.class, (String)"variable").toString()).isEqualTo("variable");
    }

    @Test
    public void datePathClassOfTPathOfQString() {
        Assertions.assertThat((String)Expressions.datePath(Date.class, (Path)Expressions.path(Object.class, (String)"variable"), (String)"property").toString()).isEqualTo("variable.property");
    }

    @Test
    public void dateTimePathClassOfTString() {
        Assertions.assertThat((String)Expressions.dateTimePath(Date.class, (String)"variable").toString()).isEqualTo("variable");
    }

    @Test
    public void dateTimePathClassOfTPathOfQString() {
        Assertions.assertThat((String)Expressions.dateTimePath(Date.class, (Path)Expressions.path(Object.class, (String)"variable"), (String)"property").toString()).isEqualTo("variable.property");
    }

    @Test
    public void timePathClassOfTString() {
        Assertions.assertThat((String)Expressions.timePath(Date.class, (String)"variable").toString()).isEqualTo("variable");
    }

    @Test
    public void timePathClassOfTPathOfQString() {
        Assertions.assertThat((String)Expressions.timePath(Date.class, (Path)Expressions.path(Object.class, (String)"variable"), (String)"property").toString()).isEqualTo("variable.property");
    }

    @Test
    public void numberPathClassOfTString() {
        Assertions.assertThat((String)Expressions.numberPath(Integer.class, (String)"variable").toString()).isEqualTo("variable");
    }

    @Test
    public void numberPathClassOfTPathOfQString() {
        Assertions.assertThat((String)Expressions.numberPath(Integer.class, (Path)Expressions.path(Object.class, (String)"variable"), (String)"property").toString()).isEqualTo("variable.property");
    }

    @Test
    public void stringPathString() {
        Assertions.assertThat((String)Expressions.stringPath((String)"variable").toString()).isEqualTo("variable");
    }

    @Test
    public void stringPathPathOfQString() {
        Assertions.assertThat((String)Expressions.stringPath((Path)Expressions.path(Object.class, (String)"variable"), (String)"property").toString()).isEqualTo("variable.property");
    }

    @Test
    public void stringOperation() {
        Assertions.assertThat((String)Expressions.stringOperation((Operator)Ops.SUBSTR_1ARG, (Expression[])new Expression[]{str, ConstantImpl.create((int)2)}).toString()).isEqualTo("substring(str,2)");
    }

    @Test
    public void booleanPathString() {
        Assertions.assertThat((String)Expressions.booleanPath((String)"variable").toString()).isEqualTo("variable");
    }

    @Test
    public void booleanPathPathOfQString() {
        Assertions.assertThat((String)Expressions.booleanPath((Path)Expressions.path(Object.class, (String)"variable"), (String)"property").toString()).isEqualTo("variable.property");
    }

    @Test
    public void booleanOperation() {
        Assertions.assertThat((String)Expressions.booleanOperation((Operator)Ops.AND, (Expression[])new Expression[]{a, b}).toString()).isEqualTo("a && b");
    }

    @Test
    public void comparableOperation() {
        Assertions.assertThat((String)Expressions.comparableOperation(Boolean.class, (Operator)Ops.AND, (Expression[])new Expression[]{a, b}).toString()).isEqualTo("a && b");
    }

    @Test
    public void dateOperation() {
        Assertions.assertThat((String)Expressions.dateOperation(Date.class, (Operator)Ops.DateTimeOps.CURRENT_DATE, (Expression[])new Expression[0]).toString()).isEqualTo("current_date()");
    }

    @Test
    public void dateTimeOperation() {
        Assertions.assertThat((String)Expressions.dateTimeOperation(Date.class, (Operator)Ops.DateTimeOps.CURRENT_TIMESTAMP, (Expression[])new Expression[0]).toString()).isEqualTo("current_timestamp()");
    }

    @Test
    public void timeOperation() {
        Assertions.assertThat((String)Expressions.timeOperation(Time.class, (Operator)Ops.DateTimeOps.CURRENT_TIME, (Expression[])new Expression[0]).toString()).isEqualTo("current_time()");
    }

    @Test
    public void cases() {
    }

    @Test
    public void asBoolean_returns_a_corresponding_BooleanExpression_for_a_given_Expression() {
        Assertions.assertThat((String)Expressions.asBoolean((Expression)Expressions.constant((Object)true)).isTrue().toString()).isEqualTo("true = true");
    }

    @Test
    public void asBoolean_returns_a_corresponding_BooleanExpression_for_a_given_Constant() {
        Assertions.assertThat((String)Expressions.asBoolean((boolean)true).isTrue().toString()).isEqualTo("true = true");
    }

    @Test
    public void asBoolean_equals_works_for_returned_values() {
        Assertions.assertThat((Object)Expressions.asBoolean((boolean)true)).isEqualTo((Object)Expressions.asBoolean((boolean)true));
        Assertions.assertThat((Object)Expressions.asBoolean((boolean)false)).isNotEqualTo((Object)Expressions.asBoolean((boolean)true));
    }

    @Test
    public void asComparable_returns_a_corresponding_ComparableExpression_for_a_given_Expression() {
        Assertions.assertThat((String)Expressions.asComparable((Expression)Expressions.constant((Object)1L)).eq(Expressions.constant((Object)1L)).toString()).isEqualTo("1 = 1");
    }

    @Test
    public void asComparable_returns_a_corresponding_ComparableExpression_for_a_given_Constant() {
        Assertions.assertThat((String)Expressions.asComparable((Comparable)Long.valueOf(1L)).eq((Object)1L).toString()).isEqualTo("1 = 1");
    }

    @Test
    public void asComparable_equals_works_for_returned_values() {
        Assertions.assertThat((Object)Expressions.asComparable((Comparable)Long.valueOf(1L))).isEqualTo((Object)Expressions.asComparable((Comparable)Long.valueOf(1L)));
        Assertions.assertThat((Object)Expressions.asComparable((Comparable)Long.valueOf(2L))).isNotEqualTo((Object)Expressions.asComparable((Comparable)Long.valueOf(1L)));
    }

    @Test
    public void asDate_returns_a_corresponding_DateExpression_for_a_given_Expression() {
        Assertions.assertThat((String)Expressions.asDate((Expression)Expressions.constant((Object)new Date(1L))).year().toString()).isEqualTo("year(Thu Jan 01 00:00:00 UTC 1970)");
    }

    @Test
    public void asDate_returns_a_corresponding_DateExpression_for_a_given_Constant() {
        Assertions.assertThat((String)Expressions.asDate((Comparable)new Date(1L)).year().toString()).isEqualTo("year(Thu Jan 01 00:00:00 UTC 1970)");
    }

    @Test
    public void asDate_equals_works_for_returned_values() {
        Assertions.assertThat((Object)Expressions.asDate((Comparable)new Date(1L)).year()).isEqualTo((Object)Expressions.asDate((Comparable)new Date(1L)).year());
        Assertions.assertThat((Object)Expressions.asDate((Comparable)new Date(2L)).year()).isNotEqualTo((Object)Expressions.asDate((Comparable)new Date(1L)).year());
    }

    @Test
    public void asDateTime_returns_a_corresponding_DateTimeExpression_for_a_given_Expression() {
        Assertions.assertThat((String)Expressions.asDateTime((Expression)Expressions.constant((Object)new Date(1L))).min().toString()).isEqualTo("min(Thu Jan 01 00:00:00 UTC 1970)");
    }

    @Test
    public void asDateTime_returns_a_corresponding_DateTimeExpression_for_a_given_Constant() {
        Assertions.assertThat((String)Expressions.asDateTime((Comparable)new Date(1L)).min().toString()).isEqualTo("min(Thu Jan 01 00:00:00 UTC 1970)");
    }

    @Test
    public void asDateTime_equals_works_for_returned_values() {
        Assertions.assertThat((Object)Expressions.asDateTime((Comparable)new Date(1L)).min()).isEqualTo((Object)Expressions.asDateTime((Comparable)new Date(1L)).min());
        Assertions.assertThat((Object)Expressions.asDateTime((Comparable)new Date(2L)).min()).isNotEqualTo((Object)Expressions.asDateTime((Comparable)new Date(1L)).min());
    }

    @Test
    public void asTime_returns_a_corresponding_TimeExpression_for_a_given_Expression() {
        Assertions.assertThat((String)Expressions.asTime((Expression)Expressions.constant((Object)new Date(1L))).hour().toString()).isEqualTo("hour(Thu Jan 01 00:00:00 UTC 1970)");
    }

    @Test
    public void asTime_returns_a_corresponding_TimeExpression_for_a_given_Constant() {
        Assertions.assertThat((String)Expressions.asTime((Comparable)new Date(1L)).hour().toString()).isEqualTo("hour(Thu Jan 01 00:00:00 UTC 1970)");
    }

    @Test
    public void asTime_equals_works_for_returned_values() {
        Assertions.assertThat((Object)Expressions.asTime((Comparable)new Date(1L)).hour()).isEqualTo((Object)Expressions.asTime((Comparable)new Date(1L)).hour());
        Assertions.assertThat((Object)Expressions.asTime((Comparable)new Date(2L)).hour()).isNotEqualTo((Object)Expressions.asTime((Comparable)new Date(1L)).hour());
    }

    @Test
    public void asEnum_returns_a_corresponding_EnumExpression_for_a_given_Expression() {
        Assertions.assertThat((String)Expressions.asEnum((Expression)Expressions.constant((Object)((Object)testEnum.TEST))).ordinal().toString()).isEqualTo("ordinal(TEST)");
    }

    @Test
    public void asEnum_returns_a_corresponding_EnumExpression_for_a_given_Constant() {
        Assertions.assertThat((String)Expressions.asEnum((Enum)testEnum.TEST).ordinal().toString()).isEqualTo("ordinal(TEST)");
    }

    @Test
    public void asEnum_equals_works_for_returned_values() {
        Assertions.assertThat((Object)Expressions.asEnum((Enum)testEnum.TEST)).isEqualTo((Object)Expressions.asEnum((Enum)testEnum.TEST));
        Assertions.assertThat((Object)Expressions.asEnum((Enum)testEnum.TEST_2)).isNotEqualTo((Object)Expressions.asEnum((Enum)testEnum.TEST));
    }

    @Test
    public void asNumber_returns_a_corresponding_NumberExpression_for_a_given_Expression() {
        Assertions.assertThat((String)Expressions.asNumber((Expression)Expressions.constant((Object)1L)).add(Expressions.constant((Object)1L)).toString()).isEqualTo("1 + 1");
    }

    @Test
    public void asNumber_returns_a_corresponding_NumberExpression_for_a_given_Constant() {
        Assertions.assertThat((String)Expressions.asNumber((Number)1L).add(Expressions.constant((Object)1L)).toString()).isEqualTo("1 + 1");
    }

    @Test
    public void asNumber_equals_works_for_returned_values() {
        Assertions.assertThat((Object)Expressions.asNumber((Number)42L)).isEqualTo((Object)Expressions.asNumber((Number)42L));
        Assertions.assertThat((Object)Expressions.asNumber((Number)256L)).isNotEqualTo((Object)Expressions.asNumber((Number)42L));
    }

    @Test
    public void asString_returns_a_corresponding_StringExpression_for_a_given_Expression() {
        Assertions.assertThat((String)Expressions.asString((Expression)Expressions.constant((Object)"left")).append(Expressions.constant((Object)"right")).toString()).isEqualTo("left + right");
    }

    @Test
    public void asString_returns_a_corresponding_StringExpression_for_a_given_Constant() {
        Assertions.assertThat((String)Expressions.asString((String)"left").append(Expressions.constant((Object)"right")).toString()).isEqualTo("left + right");
    }

    @Test
    public void asString_equals_works_for_returned_values() {
        Assertions.assertThat((Object)Expressions.asString((String)"foo")).isEqualTo((Object)Expressions.asString((String)"foo"));
        Assertions.assertThat((Object)Expressions.asString((String)"bar")).isNotEqualTo((Object)Expressions.asString((String)"foo"));
    }

    private static enum testEnum {
        TEST,
        TEST_2;

    }
}

