/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Templates;
import com.querydsl.core.types.ToStringVisitor;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.BooleanOperation;
import com.querydsl.core.types.dsl.ComparableOperation;
import com.querydsl.core.types.dsl.DateOperation;
import com.querydsl.core.types.dsl.DateTimeOperation;
import com.querydsl.core.types.dsl.EnumOperation;
import com.querydsl.core.types.dsl.NumberOperation;
import com.querydsl.core.types.dsl.SimpleOperation;
import com.querydsl.core.types.dsl.StringOperation;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.TimeOperation;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class OperationTest {
    @Test
    public void various() {
        Expression[] args = new Expression[]{new StringPath("x"), new StringPath("y")};
        ArrayList<Object> operations = new ArrayList<Object>();
        operations.add(new BooleanOperation((Operator)Ops.EQ, args));
        operations.add(new ComparableOperation(String.class, (Operator)Ops.SUBSTR_1ARG, args));
        operations.add(new DateOperation(Date.class, (Operator)Ops.DateTimeOps.CURRENT_DATE, args));
        operations.add(new DateTimeOperation(Date.class, (Operator)Ops.DateTimeOps.CURRENT_TIMESTAMP, args));
        operations.add(new EnumOperation(ExampleEnum.class, (Operator)Ops.ALIAS, args));
        operations.add(new NumberOperation(Integer.class, (Operator)Ops.ADD, args));
        operations.add(new SimpleOperation(String.class, (Operator)Ops.TRIM, args));
        operations.add(new StringOperation((Operator)Ops.CONCAT, args));
        operations.add(new TimeOperation(Time.class, (Operator)Ops.DateTimeOps.CURRENT_TIME, args));
        for (Operation operation : operations) {
            Operation other = ExpressionUtils.operation((Class)operation.getType(), (Operator)operation.getOperator(), new ArrayList(operation.getArgs()));
            Assertions.assertThat((String)((String)operation.accept((Visitor)ToStringVisitor.DEFAULT, (Object)Templates.DEFAULT))).isEqualTo(operation.toString());
            Assertions.assertThat((int)other.hashCode()).isEqualTo(operation.hashCode());
            Assertions.assertThat((Object)other).isEqualTo((Object)operation);
            Assertions.assertThat((Object)operation.getOperator()).isNotNull();
            Assertions.assertThat((List)operation.getArgs()).isNotNull();
            Assertions.assertThat((Class)operation.getType()).isNotNull();
        }
    }

    static enum ExampleEnum {
        A,
        B;

    }
}

