/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.ArrayPath;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.Gender;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.PathBuilderValidator;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.User;
import com.querydsl.core.util.BeanMap;
import java.sql.Time;
import java.util.Date;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class PathBuilderTest {
    @Test
    public void getEnum() {
        PathBuilder entityPath = new PathBuilder(User.class, "entity");
        EnumPath enumPath = entityPath.getEnum("gender", Gender.class);
        Assertions.assertThat((Object)enumPath.ordinal()).isNotNull();
        Assertions.assertThat((Object)entityPath.get(enumPath)).isEqualTo((Object)enumPath);
    }

    @Test
    public void getByExample() {
        User user = new User();
        user.setFirstName("firstName");
        user.setLastName("lastName");
        String byExample = this.getByExample(user).toString();
        Assertions.assertThat((String)byExample).contains(new CharSequence[]{"entity.lastName = lastName"});
        Assertions.assertThat((String)byExample).contains(new CharSequence[]{"entity.firstName = firstName"});
    }

    @Test
    public void getArray() {
        PathBuilder entityPath = new PathBuilder(User.class, "entity");
        ArrayPath array = entityPath.getArray("array", String[].class);
        Assertions.assertThat((Class)array.getType()).isEqualTo(String[].class);
        Assertions.assertThat((Class)array.getElementType()).isEqualTo(String.class);
    }

    @Test
    public void getList() {
        PathBuilder entityPath = new PathBuilder(User.class, "entity");
        ((StringPath)entityPath.getList("list", String.class, StringPath.class).get(0)).lower();
        entityPath.getList("list", String.class).get(0);
    }

    @Test
    public void getMap() {
        PathBuilder entityPath = new PathBuilder(User.class, "entity");
        ((StringPath)entityPath.getMap("map", String.class, String.class, StringPath.class).get((Object)"")).lower();
        entityPath.getMap("map", String.class, String.class).get((Object)"");
    }

    private <T> BooleanBuilder getByExample(T entity) {
        PathBuilder entityPath = new PathBuilder(entity.getClass(), "entity");
        BooleanBuilder conditions = new BooleanBuilder();
        BeanMap beanMap = new BeanMap(entity);
        for (Map.Entry entry : beanMap.entrySet()) {
            if (((String)entry.getKey()).equals("class") || entry.getValue() == null) continue;
            conditions.and((Predicate)entityPath.get((String)entry.getKey()).eq(entry.getValue()));
        }
        return conditions;
    }

    @Test
    public void get() {
        PathBuilder entity = new PathBuilder(User.class, "entity");
        NumberPath intPath = new NumberPath(Integer.class, "int");
        StringPath strPath = new StringPath("str");
        BooleanPath booleanPath = new BooleanPath("boolean");
        Assertions.assertThat((String)entity.get(intPath).toString()).isEqualTo("entity.int");
        Assertions.assertThat((String)entity.get(strPath).toString()).isEqualTo("entity.str");
        Assertions.assertThat((String)entity.get(booleanPath).toString()).isEqualTo("entity.boolean");
        Assertions.assertThat((String)entity.get(entity.get(intPath)).toString()).isEqualTo("entity.int");
    }

    @Test
    public void various() {
        PathBuilder entity = new PathBuilder(User.class, "entity");
        entity.getBoolean("boolean");
        entity.getCollection("col", User.class);
        entity.getComparable("comparable", Comparable.class);
        entity.getDate("date", Date.class);
        entity.getDateTime("dateTime", Date.class);
        entity.getList("list", User.class);
        entity.getMap("map", String.class, User.class);
        entity.getNumber("number", Integer.class);
        entity.getSet("set", User.class);
        entity.getSimple("simple", Object.class);
        entity.getString("string");
        entity.getTime("time", Time.class);
    }

    @Test
    public void calling_get_with_the_same_name_and_different_types_returns_correct_type() {
        PathBuilder entity = new PathBuilder(User.class, "entity");
        String pathName = "some_path";
        Assertions.assertThat((Class)entity.get(pathName).getType()).isEqualTo(Object.class);
        Assertions.assertThat((Class)entity.get(pathName, Integer.class).getType()).isEqualTo(Integer.class);
        Assertions.assertThat((Class)entity.get(pathName, User.class).getType()).isEqualTo(User.class);
    }

    @Test
    public void calling_get_with_the_same_name_and_different_types_returns_specific_type_when_validating() {
        PathBuilder entity = new PathBuilder(User.class, "entity", PathBuilderValidator.FIELDS);
        String pathName = "username";
        Assertions.assertThat((Class)entity.get(pathName).getType()).isEqualTo(String.class);
        Assertions.assertThat((Class)entity.get(pathName, Comparable.class).getType()).isEqualTo(String.class);
        Assertions.assertThat((Class)entity.get(pathName, Object.class).getType()).isEqualTo(String.class);
    }
}

