/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.types.dsl.PathBuilderValidator;
import java.util.Collection;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class PathBuilderValidatorTest {
    @Test
    public void defaults() {
        Assertions.assertThat((Class)PathBuilderValidator.DEFAULT.validate(Customer.class, "name", String.class)).isEqualTo(String.class);
        Assertions.assertThat((Class)PathBuilderValidator.DEFAULT.validate(ExtendedCustomer.class, "name", String.class)).isEqualTo(String.class);
        Assertions.assertThat((Class)PathBuilderValidator.DEFAULT.validate(Project.class, "name", String.class)).isEqualTo(String.class);
        Assertions.assertThat((Class)PathBuilderValidator.DEFAULT.validate(ExtendedProject.class, "name", String.class)).isEqualTo(String.class);
    }

    @Test
    public void fields() {
        Assertions.assertThat((Class)PathBuilderValidator.FIELDS.validate(Customer.class, "name", String.class)).isEqualTo(String.class);
        Assertions.assertThat((Class)PathBuilderValidator.FIELDS.validate(ExtendedCustomer.class, "name", String.class)).isEqualTo(String.class);
        Assertions.assertThat((Class)PathBuilderValidator.FIELDS.validate(Customer.class, "collection", Collection.class)).isEqualTo(Integer.class);
        Assertions.assertThat((Class)PathBuilderValidator.FIELDS.validate(Customer.class, "map", Map.class)).isEqualTo(Integer.class);
        Assertions.assertThat((Class)PathBuilderValidator.FIELDS.validate(Project.class, "name", String.class)).isNull();
        Assertions.assertThat((Class)PathBuilderValidator.FIELDS.validate(ExtendedProject.class, "name", String.class)).isNull();
    }

    @Test
    public void properties() {
        Assertions.assertThat((Class)PathBuilderValidator.PROPERTIES.validate(Customer.class, "name", String.class)).isNull();
        Assertions.assertThat((Class)PathBuilderValidator.PROPERTIES.validate(ExtendedCustomer.class, "name", String.class)).isNull();
        Assertions.assertThat((Class)PathBuilderValidator.PROPERTIES.validate(Project.class, "name", String.class)).isEqualTo(String.class);
        Assertions.assertThat((Class)PathBuilderValidator.PROPERTIES.validate(ExtendedProject.class, "name", String.class)).isEqualTo(String.class);
        Assertions.assertThat((Class)PathBuilderValidator.PROPERTIES.validate(ExtendedProject.class, "started", Boolean.class)).isEqualTo(Boolean.class);
        Assertions.assertThat((Class)PathBuilderValidator.PROPERTIES.validate(Project.class, "collection", Collection.class)).isEqualTo(Integer.class);
        Assertions.assertThat((Class)PathBuilderValidator.PROPERTIES.validate(Project.class, "map", Map.class)).isEqualTo(Integer.class);
    }

    public static class Customer {
        String name;
        Collection<Integer> collection;
        Map<String, Integer> map;
    }

    public static class ExtendedCustomer
    extends Customer {
    }

    public static class Project {
        public String getName() {
            return "";
        }

        public Collection<Integer> getCollection() {
            return null;
        }

        public Map<String, Integer> getMap() {
            return null;
        }
    }

    public static class ExtendedProject
    extends Project {
        public boolean isStarted() {
            return true;
        }
    }
}

