/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.alias.Alias;
import com.querydsl.core.annotations.QueryEntity;
import com.querydsl.core.annotations.QueryTransient;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathMetadataFactory;
import com.querydsl.core.types.Templates;
import com.querydsl.core.types.ToStringVisitor;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.ArrayPath;
import com.querydsl.core.types.dsl.BeanPath;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.CollectionPath;
import com.querydsl.core.types.dsl.ComparablePath;
import com.querydsl.core.types.dsl.DatePath;
import com.querydsl.core.types.dsl.DateTimePath;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.ListPath;
import com.querydsl.core.types.dsl.MapPath;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SetPath;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.TimePath;
import com.querydsl.core.util.Annotations;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class PathTest {
    @Test
    public void getAnnotatedElement() {
        Entity entity = (Entity)Alias.alias(Entity.class);
        AnnotatedElement element = Alias.$((Object)entity).getAnnotatedElement();
        Assertions.assertThat((Object)element).isEqualTo(Entity.class);
    }

    @Test
    public void getAnnotatedElement_for_property() {
        Entity entity = (Entity)Alias.alias(Entity.class);
        AnnotatedElement property1 = Alias.$((String)entity.getProperty1()).getAnnotatedElement();
        AnnotatedElement property2 = Alias.$((String)entity.getProperty2()).getAnnotatedElement();
        AnnotatedElement property3 = Alias.$((String)entity.getProperty3()).getAnnotatedElement();
        AnnotatedElement property4 = Alias.$((String)entity.getProperty4()).getAnnotatedElement();
        Assertions.assertThat(property1.getClass()).isEqualTo(Annotations.class);
        Assertions.assertThat(property2.getClass()).isEqualTo(Annotations.class);
        Assertions.assertThat(property3.getClass()).isEqualTo(Field.class);
        Assertions.assertThat((boolean)property3.isAnnotationPresent(QueryTransient.class)).isTrue();
        Assertions.assertThat((Object)property3.getAnnotation(QueryTransient.class)).isNotNull();
        Assertions.assertThat(property4.getClass()).isEqualTo(Annotations.class);
    }

    @Test
    public void equals() {
        Assertions.assertThat((Object)new StringPath("s")).isEqualTo((Object)new StringPath("s"));
        Assertions.assertThat((Object)new BooleanPath("b")).isEqualTo((Object)new BooleanPath("b"));
        Assertions.assertThat((Object)new NumberPath(Integer.class, "n")).isEqualTo((Object)new NumberPath(Integer.class, "n"));
        Assertions.assertThat((Object)ExpressionUtils.path(String.class, (String)"p")).isEqualTo((Object)new ArrayPath(String[].class, "p"));
        Assertions.assertThat((Object)ExpressionUtils.path(Boolean.class, (String)"p")).isEqualTo((Object)new BooleanPath("p"));
        Assertions.assertThat((Object)ExpressionUtils.path(String.class, (String)"p")).isEqualTo((Object)new ComparablePath(String.class, "p"));
        Assertions.assertThat((Object)ExpressionUtils.path(Date.class, (String)"p")).isEqualTo((Object)new DatePath(Date.class, "p"));
        Assertions.assertThat((Object)ExpressionUtils.path(Date.class, (String)"p")).isEqualTo((Object)new DateTimePath(Date.class, "p"));
        Assertions.assertThat((Object)ExpressionUtils.path(ExampleEnum.class, (String)"p")).isEqualTo((Object)new EnumPath(ExampleEnum.class, "p"));
        Assertions.assertThat((Object)ExpressionUtils.path(Integer.class, (String)"p")).isEqualTo((Object)new NumberPath(Integer.class, "p"));
        Assertions.assertThat((Object)ExpressionUtils.path(String.class, (String)"p")).isEqualTo((Object)new StringPath("p"));
        Assertions.assertThat((Object)ExpressionUtils.path(Time.class, (String)"p")).isEqualTo((Object)new TimePath(Time.class, "p"));
    }

    @Test
    public void various_properties() {
        Path parent = ExpressionUtils.path(Object.class, (String)"parent");
        ArrayList<Object> paths = new ArrayList<Object>();
        paths.add(new ArrayPath(String[].class, parent, "p"));
        paths.add(new BeanPath(Object.class, parent, "p"));
        paths.add(new BooleanPath(parent, "p"));
        paths.add(new CollectionPath(String.class, StringPath.class, parent, "p"));
        paths.add(new ComparablePath(String.class, parent, "p"));
        paths.add(new DatePath(Date.class, parent, "p"));
        paths.add(new DateTimePath(Date.class, parent, "p"));
        paths.add(new EnumPath(ExampleEnum.class, parent, "p"));
        paths.add(new ListPath(String.class, StringPath.class, parent, "p"));
        paths.add(new MapPath(String.class, String.class, StringPath.class, parent, "p"));
        paths.add(new NumberPath(Integer.class, parent, "p"));
        paths.add(new SetPath(String.class, StringPath.class, parent, "p"));
        paths.add(new SimplePath(String.class, parent, "p"));
        paths.add(new StringPath(parent, "p"));
        paths.add(new TimePath(Time.class, parent, "p"));
        for (Path path : paths) {
            Path other = ExpressionUtils.path((Class)path.getType(), (PathMetadata)PathMetadataFactory.forProperty((Path)parent, (String)"p"));
            Assertions.assertThat((String)((String)path.accept((Visitor)ToStringVisitor.DEFAULT, (Object)Templates.DEFAULT))).isEqualTo(path.toString());
            Assertions.assertThat((int)other.hashCode()).isEqualTo(path.hashCode());
            Assertions.assertThat((Object)other).isEqualTo((Object)path);
            Assertions.assertThat((Object)path.getMetadata()).isNotNull();
            Assertions.assertThat((Class)path.getType()).isNotNull();
            Assertions.assertThat((Object)path.getRoot()).isEqualTo((Object)parent);
        }
    }

    @Test
    public void various() {
        ArrayList<Object> paths = new ArrayList<Object>();
        paths.add(new ArrayPath(String[].class, "p"));
        paths.add(new BeanPath(Object.class, "p"));
        paths.add(new BooleanPath("p"));
        paths.add(new CollectionPath(String.class, StringPath.class, "p"));
        paths.add(new ComparablePath(String.class, "p"));
        paths.add(new DatePath(Date.class, "p"));
        paths.add(new DateTimePath(Date.class, "p"));
        paths.add(new EnumPath(ExampleEnum.class, "p"));
        paths.add(new ListPath(String.class, StringPath.class, "p"));
        paths.add(new MapPath(String.class, String.class, StringPath.class, "p"));
        paths.add(new NumberPath(Integer.class, "p"));
        paths.add(new SetPath(String.class, StringPath.class, "p"));
        paths.add(new SimplePath(String.class, "p"));
        paths.add(new StringPath("p"));
        paths.add(new TimePath(Time.class, "p"));
        for (Path path : paths) {
            Path other = ExpressionUtils.path((Class)path.getType(), (String)"p");
            Assertions.assertThat((String)((String)path.accept((Visitor)ToStringVisitor.DEFAULT, null))).isEqualTo(path.toString());
            Assertions.assertThat((int)other.hashCode()).isEqualTo(path.hashCode());
            Assertions.assertThat((Object)other).isEqualTo((Object)path);
            Assertions.assertThat((Object)path.getMetadata()).isNotNull();
            Assertions.assertThat((Class)path.getType()).isNotNull();
            Assertions.assertThat((Object)path.getRoot()).isEqualTo((Object)path);
        }
    }

    @Test
    public void parent_path() {
        Path person = ExpressionUtils.path(Object.class, (String)"person");
        Path name = ExpressionUtils.path(String.class, (Path)person, (String)"name");
        Assertions.assertThat((String)name.toString()).isEqualTo("person.name");
    }

    @QueryEntity
    public static class Entity
    extends Superclass {
        @Nullable
        private String property1;
        private String property2;
        @QueryTransient
        private String property3;

        public String getProperty1() {
            return this.property1;
        }

        @NotNull
        public String getProperty2() {
            return this.property2;
        }

        @NotNull
        public String getProperty3() {
            return this.property3;
        }
    }

    static enum ExampleEnum {
        A,
        B;

    }

    public static class Superclass {
        @Nullable
        public String getProperty4() {
            return null;
        }
    }
}

