/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.util;

import com.querydsl.core.util.BeanMap;
import com.querydsl.core.util.Entity;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class BeanMapTest {
    private BeanMap beanMap;

    @Before
    public void setUp() {
        this.beanMap = new BeanMap((Object)new Entity());
    }

    @Test
    public void size() {
        Assertions.assertThat((int)this.beanMap.size()).isEqualTo(4);
    }

    @Test
    public void clear() {
        this.beanMap.clear();
        Assertions.assertThat((int)this.beanMap.size()).isEqualTo(4);
    }

    @Test
    public void primitives() {
        this.beanMap.put("id", (Object)5);
        Assertions.assertThat((int)((Entity)this.beanMap.getBean()).getId()).isEqualTo(5);
    }

    @Test
    public void beanMap() {
        Assertions.assertThat((int)new BeanMap().size()).isEqualTo(0);
    }

    @Test
    public void beanMapObject() {
        Assertions.assertThat((int)new BeanMap((Object)new Entity()).size()).isEqualTo(4);
    }

    @Test
    public void toString_() {
        Assertions.assertThat((String)new BeanMap().toString()).isEqualTo("BeanMap<null>");
    }

    @Test
    public void clone_() throws CloneNotSupportedException {
        Assertions.assertThat((Object)this.beanMap.clone()).isEqualTo((Object)this.beanMap);
    }

    @Test
    public void putAllWriteable() {
    }

    @Test
    public void containsKeyString() {
        Assertions.assertThat((boolean)this.beanMap.containsKey("id")).isTrue();
    }

    @Test
    public void containsValueObject() {
    }

    @Test
    public void getString() {
        this.beanMap.put("firstName", (Object)"John");
        Assertions.assertThat((Object)this.beanMap.get("firstName")).isEqualTo((Object)"John");
    }

    @Test
    public void keySet() {
        Assertions.assertThat((Collection)this.beanMap.keySet()).isEqualTo(new HashSet<String>(Arrays.asList("id", "class", "firstName", "lastName")));
    }

    @Test
    public void entrySet() {
        this.beanMap.put("firstName", (Object)"John");
        Assertions.assertThat((Collection)this.beanMap.entrySet()).isNotEmpty();
    }

    @Test
    @Ignore
    public void values() {
        this.beanMap.put("firstName", (Object)"John");
        Assertions.assertThat((Collection)this.beanMap.values()).isEqualTo(Arrays.asList(0, null, Entity.class, "John"));
    }

    @Test
    public void getType() {
    }

    @Test
    public void getBean() {
        Assertions.assertThat(this.beanMap.getBean().getClass()).isEqualTo(Entity.class);
    }

    @Test
    public void setBean() {
        Entity entity = new Entity();
        this.beanMap.setBean((Object)entity);
        Assertions.assertThat((entity == this.beanMap.getBean() ? 1 : 0) != 0).isTrue();
    }
}

