/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.util;

import com.querydsl.core.types.ProjectionExample;
import com.querydsl.core.util.ArrayUtils;
import com.querydsl.core.util.ConstructorUtils;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.Test;

public class ConstructorUtilsTest {
    @Test
    public void getDefaultConstructor() {
        Class[] args = new Class[]{};
        Constructor<ProjectionExample> emptyDefaultConstructor = this.getConstructor(ProjectionExample.class, args);
        Constructor<ProjectionExample> nullDefaultConstructor = this.getConstructor(ProjectionExample.class, null);
        Assertions.assertThat(emptyDefaultConstructor).isNotNull();
        Assertions.assertThat(nullDefaultConstructor).isNotNull();
        Assertions.assertThat((ArrayUtils.isEmpty((Object[])emptyDefaultConstructor.getParameterTypes()) && ArrayUtils.isEmpty((Object[])nullDefaultConstructor.getParameterTypes()) ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void getSimpleConstructor() {
        Object[] args = new Class[]{Long.class};
        Constructor<ProjectionExample> constructor = this.getConstructor((Class)ProjectionExample.class, (Class<?>[])args);
        Assertions.assertThat(constructor).isNotNull();
        Assertions.assertThat((Object[])constructor.getParameterTypes()).containsExactly(args);
    }

    @Test
    public void getDefaultConstructorParameters() {
        Class[] args = new Class[]{Long.class, String.class};
        Object[] expected = new Class[]{Long.TYPE, String.class};
        Object[] constructorParameters = ConstructorUtils.getConstructorParameters(ProjectionExample.class, (Class[])args);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])constructorParameters).as("Constructorparameters not equal", new Object[0])).containsExactly(expected);
    }

    private <C> Constructor<C> getConstructor(Class<C> type, Class<?>[] givenTypes) {
        Constructor rv = null;
        try {
            rv = ConstructorUtils.getConstructor(type, (Class[])givenTypes);
        }
        catch (NoSuchMethodException ex) {
            Assertions.fail((String)"", (Object[])new Object[]{"No constructor found for " + type.toString() + " with parameters: " + Arrays.toString(givenTypes)});
        }
        return rv;
    }
}

