/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.util;

import com.querydsl.core.util.MathUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class MathUtilsTest {
    @Test
    public void sum() {
        Assertions.assertThat((Integer)((Integer)MathUtils.sum((Number)2, (Number)3.0))).isEqualTo((Object)5);
    }

    @Test
    public void difference() {
        Assertions.assertThat((Integer)((Integer)MathUtils.difference((Number)5, (Number)3.0))).isEqualTo((Object)2);
    }

    @Test
    public void cast_returns_correct_type() {
        MathUtilsTest.checkCast(1, BigDecimal.class);
        MathUtilsTest.checkCast(1, BigInteger.class);
        MathUtilsTest.checkCast(1, Double.class);
        MathUtilsTest.checkCast(1, Float.class);
        MathUtilsTest.checkCast(1, Integer.class);
        MathUtilsTest.checkCast(1, Long.class);
        MathUtilsTest.checkCast(1, Short.class);
        MathUtilsTest.checkCast(1, Byte.class);
    }

    @Test
    public void cast_returns_argument_as_is_when_compatible() {
        MathUtilsTest.checkSame(BigDecimal.ONE, BigDecimal.class);
        MathUtilsTest.checkSame(BigInteger.ONE, BigInteger.class);
        MathUtilsTest.checkSame(1.0, Double.class);
        MathUtilsTest.checkSame(Float.valueOf(1.0f), Float.class);
        MathUtilsTest.checkSame(1, Integer.class);
        MathUtilsTest.checkSame(1L, Long.class);
        MathUtilsTest.checkSame((short)1, Short.class);
        MathUtilsTest.checkSame((byte)1, Byte.class);
    }

    @Test
    public void cast_returns_null_when_input_is_null() {
        Integer result = (Integer)MathUtils.cast(null, Integer.class);
        Assertions.assertThat((Integer)result).isNull();
    }

    @Test
    public void cast_throws_on_unsupported_numbers() {
        Throwable exception = org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> MathUtilsTest.checkCast(1, AtomicInteger.class));
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"Unsupported target type"});
    }

    private static void checkCast(Number value, Class<? extends Number> targetClass) {
        Number target = MathUtils.cast((Number)value, targetClass);
        Assertions.assertThat(target.getClass()).isSameAs(targetClass);
    }

    private static <N extends Number> void checkSame(N value, Class<N> targetClass) {
        Number target = MathUtils.cast(value, targetClass);
        Assertions.assertThat((Object)target).isSameAs(value);
    }
}

