/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.util;

import com.mysema.commons.lang.IteratorAdapter;
import com.querydsl.core.util.MultiIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class MultiIteratorTest {
    private MultiIterator it;
    private List<Integer> list1 = Arrays.asList(1, 2);
    private List<Integer> list2 = Collections.emptyList();
    private List<Integer> list3;
    private List<Integer> list4;

    @Test
    public void emptyList() {
        this.it = new MultiIterator(Arrays.asList(this.list1, this.list2));
        while (this.it.hasNext()) {
            this.it.next();
            Assertions.fail((String)"should return false on hasNext()");
        }
    }

    @Test
    public void oneLevel() {
        this.it = new MultiIterator(Collections.singletonList(this.list1));
        this.assertIteratorEquals(Arrays.asList(this.row(1), this.row(2)).iterator(), (Iterator<Object[]>)this.it);
    }

    @Test
    public void twoLevels() {
        this.list2 = Arrays.asList(10, 20, 30);
        this.it = new MultiIterator(Arrays.asList(this.list1, this.list2));
        Iterator<Object[]> base = Arrays.asList(this.row(1, 10), this.row(1, 20), this.row(1, 30), this.row(2, 10), this.row(2, 20), this.row(2, 30)).iterator();
        this.assertIteratorEquals(base, (Iterator<Object[]>)this.it);
    }

    @Test
    public void threeLevels() {
        this.list1 = Arrays.asList(1, 2);
        this.list2 = Arrays.asList(10, 20, 30);
        this.list3 = Arrays.asList(100, 200, 300, 400);
        this.it = new MultiIterator(Arrays.asList(this.list1, this.list2, this.list3));
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (Object a : this.row(1, 2)) {
            for (Object b : this.row(10, 20, 30)) {
                for (Object c : this.row(100, 200, 300, 400)) {
                    list.add(this.row(a, b, c));
                }
            }
        }
        this.assertIteratorEquals(list.iterator(), (Iterator<Object[]>)this.it);
    }

    @Test
    public void fourLevels() {
        this.list1 = Arrays.asList(1, 2);
        this.list2 = Arrays.asList(10, 20, 30);
        this.list3 = Arrays.asList(100, 200, 300, 400);
        this.list4 = Arrays.asList(1000, 2000, 3000, 4000, 5000);
        this.it = new MultiIterator(Arrays.asList(this.list1, this.list2, this.list3, this.list4));
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (Object a : this.row(1, 2)) {
            for (Object b : this.row(10, 20, 30)) {
                for (Object c : this.row(100, 200, 300, 400)) {
                    for (Object d : this.row(1000, 2000, 3000, 4000, 5000)) {
                        list.add(this.row(a, b, c, d));
                    }
                }
            }
        }
        this.assertIteratorEquals(list.iterator(), (Iterator<Object[]>)this.it);
    }

    @Test
    public void fourLevels2() {
        this.list1 = new ArrayList<Integer>(100);
        for (int i = 0; i < 100; ++i) {
            this.list1.add(i + 1);
        }
        this.list2 = this.list1;
        this.it = new MultiIterator(Arrays.asList(this.list1, this.list2));
        while (this.it.hasNext()) {
            this.it.next();
        }
    }

    @Test
    public void test() {
        List<Integer> list1 = Arrays.asList(1, 2, 3, 4);
        List<Integer> list2 = Arrays.asList(10, 20, 30);
        MultiIterator iterator = new MultiIterator(Arrays.asList(list1, list2));
        List list = IteratorAdapter.asList((Iterator)iterator);
        Assertions.assertThat(Arrays.asList((Object[])list.getFirst())).isEqualTo(Arrays.asList(1, 10));
        Assertions.assertThat(Arrays.asList((Object[])list.get(1))).isEqualTo(Arrays.asList(1, 20));
        Assertions.assertThat(Arrays.asList((Object[])list.get(2))).isEqualTo(Arrays.asList(1, 30));
        Assertions.assertThat(Arrays.asList((Object[])list.get(3))).isEqualTo(Arrays.asList(2, 10));
        Assertions.assertThat(Arrays.asList((Object[])list.get(4))).isEqualTo(Arrays.asList(2, 20));
        Assertions.assertThat(Arrays.asList((Object[])list.get(5))).isEqualTo(Arrays.asList(2, 30));
        Assertions.assertThat(Arrays.asList((Object[])list.get(6))).isEqualTo(Arrays.asList(3, 10));
        Assertions.assertThat(Arrays.asList((Object[])list.get(7))).isEqualTo(Arrays.asList(3, 20));
        Assertions.assertThat(Arrays.asList((Object[])list.get(8))).isEqualTo(Arrays.asList(3, 30));
        Assertions.assertThat(Arrays.asList((Object[])list.get(9))).isEqualTo(Arrays.asList(4, 10));
        Assertions.assertThat(Arrays.asList((Object[])list.get(10))).isEqualTo(Arrays.asList(4, 20));
        Assertions.assertThat(Arrays.asList((Object[])list.get(11))).isEqualTo(Arrays.asList(4, 30));
    }

    protected void assertIteratorEquals(Iterator<Object[]> a, Iterator<Object[]> b) {
        while (a.hasNext()) {
            Assertions.assertThat(Arrays.asList(b.next())).isEqualTo(Arrays.asList(a.next()));
        }
        Assertions.assertThat((boolean)b.hasNext()).isFalse();
    }

    protected Object[] row(Object ... row) {
        return row;
    }
}

