/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.group;

import com.querydsl.core.group.AbstractGroupExpression;
import com.querydsl.core.group.GroupCollector;
import com.querydsl.core.types.Expression;
import com.querydsl.core.util.MathUtils;
import java.math.BigDecimal;
import java.math.MathContext;

public class GAvg<T extends Number>
extends AbstractGroupExpression<T, T> {
    private static final long serialVersionUID = 3518868612387641383L;
    private final MathContext mathContext;

    public GAvg(Expression<T> expr) {
        this(expr, MathContext.DECIMAL128);
    }

    GAvg(Expression<T> expr, MathContext mathContext) {
        super(expr.getType(), expr);
        this.mathContext = mathContext;
    }

    @Override
    public GroupCollector<T, T> createGroupCollector() {
        return new GroupCollector<T, T>(){
            private int count = 0;
            private BigDecimal sum = BigDecimal.ZERO;

            @Override
            public void add(T t) {
                ++this.count;
                if (t != null) {
                    this.sum = this.sum.add(new BigDecimal(t.toString()));
                }
            }

            @Override
            public T get() {
                BigDecimal avg = this.sum.divide(BigDecimal.valueOf(this.count), GAvg.this.mathContext);
                return MathUtils.cast(avg, GAvg.this.getType());
            }
        };
    }
}

