/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.alias;

import com.querydsl.core.QueryException;
import com.querydsl.core.alias.ManagedObject;
import com.querydsl.core.alias.PathFactory;
import com.querydsl.core.alias.PropertyAccessInvocationHandler;
import com.querydsl.core.alias.TypeSystem;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadataFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jetbrains.annotations.Nullable;

class AliasFactory {
    private final ThreadLocal<Expression<?>> current = new ThreadLocal();
    private final PathFactory pathFactory;
    private final TypeSystem typeSystem;
    private final ConcurrentHashMap<Class<?>, Map<Expression<?>, ManagedObject>> proxyCache = new ConcurrentHashMap();

    AliasFactory(PathFactory pathFactory, TypeSystem typeSystem) {
        this.pathFactory = pathFactory;
        this.typeSystem = typeSystem;
    }

    public <A> A createAliasForExpr(Class<A> cl, Expression<? extends A> expr) {
        try {
            Map expressionCache = this.proxyCache.computeIfAbsent(cl, a -> Collections.synchronizedMap(new WeakHashMap()));
            return (A)expressionCache.computeIfAbsent(expr, e -> (ManagedObject)this.createProxy(cl, expr));
        }
        catch (ClassCastException e2) {
            throw new QueryException(e2);
        }
    }

    public <A> A createAliasForProperty(Class<A> cl, Expression<?> path) {
        return this.createProxy(cl, path);
    }

    public <A> A createAliasForVariable(Class<A> cl, String var) {
        Path<A> expr = this.pathFactory.createEntityPath(cl, PathMetadataFactory.forVariable(var));
        return this.createAliasForExpr(cl, expr);
    }

    protected <A> A createProxy(Class<A> cl, Expression<?> path) {
        Class loaded = new ByteBuddy().subclass(cl).implement(new Type[]{ManagedObject.class}).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)MethodDelegation.to((Object)new PropertyAccessInvocationHandler(path, this, this.pathFactory, this.typeSystem))).make().load(AliasFactory.class.getClassLoader()).getLoaded();
        Constructor<?> constructor = null;
        for (Constructor<?> declaredConstructor : loaded.getDeclaredConstructors()) {
            if (declaredConstructor.getParameterCount() == 0) {
                constructor = declaredConstructor;
                break;
            }
            constructor = declaredConstructor;
        }
        A result = null;
        if (constructor != null) {
            Object[] initargs = new Object[constructor.getParameterCount()];
            try {
                result = (A)constructor.newInstance(initargs);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    @Nullable
    public <A extends Expression<?>> A getCurrent() {
        return (A)this.current.get();
    }

    @Nullable
    public <A extends Expression<?>> A getCurrentAndReset() {
        A rv = this.getCurrent();
        this.reset();
        return rv;
    }

    public void reset() {
        this.current.set(null);
    }

    public void setCurrent(Expression<?> expr) {
        this.current.set(expr);
    }
}

