/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.group;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.FetchableQuery;
import com.querydsl.core.Tuple;
import com.querydsl.core.group.AbstractGroupByTransformer;
import com.querydsl.core.group.Group;
import com.querydsl.core.group.GroupExpression;
import com.querydsl.core.group.GroupImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.FactoryExpressionUtils;
import com.querydsl.core.types.Projections;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;

public class GroupByGenericCollection<K, V, RES extends Collection<V>>
extends AbstractGroupByTransformer<K, RES> {
    private final Supplier<RES> resultFactory;

    GroupByGenericCollection(Supplier<RES> resultFactory, Expression<K> key, Expression<?> ... expressions) {
        super(key, expressions);
        this.resultFactory = resultFactory;
    }

    @Override
    public RES transform(FetchableQuery<?, ?> query) {
        FactoryExpression<Tuple> expr = FactoryExpressionUtils.wrap(Projections.tuple(this.expressions));
        boolean hasGroups = false;
        for (Expression<?> e : expr.getArgs()) {
            hasGroups |= e instanceof GroupExpression;
        }
        if (hasGroups) {
            expr = GroupByGenericCollection.withoutGroupExpressions(expr);
        }
        CloseableIterator iter = query.select(expr).iterate();
        Collection list = (Collection)this.resultFactory.get();
        GroupImpl group = null;
        Object groupId = null;
        while (iter.hasNext()) {
            Object[] row = ((Tuple)iter.next()).toArray();
            if (group == null) {
                group = new GroupImpl(this.groupExpressions, this.maps);
                groupId = row[0];
            } else if (!Objects.equals(groupId, row[0])) {
                list.add(this.transform(group));
                group = new GroupImpl(this.groupExpressions, this.maps);
                groupId = row[0];
            }
            group.add(row);
        }
        if (group != null) {
            list.add(this.transform(group));
        }
        iter.close();
        return (RES)list;
    }

    protected V transform(Group group) {
        return (V)group;
    }
}

