/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.bulkhead.operator;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.reactor.bulkhead.operator.BulkheadSubscriber;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.Operators;

class FluxBulkhead<T>
extends FluxOperator<T, T> {
    private final Bulkhead bulkhead;

    FluxBulkhead(Flux<? extends T> source, Bulkhead bulkhead) {
        super(source);
        this.bulkhead = bulkhead;
    }

    public void subscribe(CoreSubscriber<? super T> actual) {
        if (this.bulkhead.tryAcquirePermission()) {
            this.source.subscribe(new BulkheadSubscriber<T>(this.bulkhead, actual, false));
        } else {
            Operators.error(actual, (Throwable)BulkheadFullException.createBulkheadFullException((Bulkhead)this.bulkhead));
        }
    }
}

