/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.configure;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.configure.BulkheadAspectExt;
import io.github.resilience4j.reactor.bulkhead.operator.BulkheadOperator;
import java.util.function.Function;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorBulkheadAspectExt
implements BulkheadAspectExt {
    private static final Logger logger = LoggerFactory.getLogger(ReactorBulkheadAspectExt.class);

    @Override
    public boolean canHandleReturnType(Class returnType) {
        return Flux.class.isAssignableFrom(returnType) || Mono.class.isAssignableFrom(returnType);
    }

    @Override
    public Object handle(ProceedingJoinPoint proceedingJoinPoint, Bulkhead bulkhead, String methodName) throws Throwable {
        Object returnValue = proceedingJoinPoint.proceed();
        if (Flux.class.isAssignableFrom(returnValue.getClass())) {
            Flux fluxReturnValue = (Flux)returnValue;
            return fluxReturnValue.compose((Function)BulkheadOperator.of((Bulkhead)bulkhead));
        }
        if (Mono.class.isAssignableFrom(returnValue.getClass())) {
            Mono monoReturnValue = (Mono)returnValue;
            return monoReturnValue.compose((Function)BulkheadOperator.of((Bulkhead)bulkhead));
        }
        logger.error("Unsupported type for Reactor BulkHead {}", (Object)returnValue.getClass().getTypeName());
        throw new IllegalArgumentException("Not Supported type for the BulkHead in Reactor :" + returnValue.getClass().getName());
    }
}

