/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.configure;

import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.retry.configuration.RetryConfigCustomizer;
import io.github.resilience4j.common.retry.configuration.RetryConfigurationProperties;
import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.registry.CompositeRegistryEventConsumer;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.fallback.FallbackDecorators;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.github.resilience4j.retry.configure.ReactorRetryAspectExt;
import io.github.resilience4j.retry.configure.RetryAspect;
import io.github.resilience4j.retry.configure.RetryAspectExt;
import io.github.resilience4j.retry.configure.RetryConfigurationProperties;
import io.github.resilience4j.retry.configure.RxJava2RetryAspectExt;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.utils.AspectJOnClasspathCondition;
import io.github.resilience4j.utils.ReactorOnClasspathCondition;
import io.github.resilience4j.utils.RxJava2OnClasspathCondition;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class RetryConfiguration {
    @Bean
    @Qualifier(value="compositeRetryCustomizer")
    public CompositeCustomizer<RetryConfigCustomizer> compositeRetryCustomizer(@Autowired(required=false) List<RetryConfigCustomizer> configCustomizers) {
        return new CompositeCustomizer(configCustomizers);
    }

    @Bean
    public RetryRegistry retryRegistry(RetryConfigurationProperties retryConfigurationProperties, EventConsumerRegistry<RetryEvent> retryEventConsumerRegistry, RegistryEventConsumer<Retry> retryRegistryEventConsumer, @Qualifier(value="compositeRetryCustomizer") CompositeCustomizer<RetryConfigCustomizer> compositeRetryCustomizer) {
        RetryRegistry retryRegistry = this.createRetryRegistry(retryConfigurationProperties, retryRegistryEventConsumer, compositeRetryCustomizer);
        this.registerEventConsumer(retryRegistry, retryEventConsumerRegistry, retryConfigurationProperties);
        retryConfigurationProperties.getInstances().forEach((name, properties) -> retryRegistry.retry(name, retryConfigurationProperties.createRetryConfig((String)name, (CompositeCustomizer)compositeRetryCustomizer)));
        return retryRegistry;
    }

    @Bean
    @Primary
    public RegistryEventConsumer<Retry> retryRegistryEventConsumer(Optional<List<RegistryEventConsumer<Retry>>> optionalRegistryEventConsumers) {
        return new CompositeRegistryEventConsumer(optionalRegistryEventConsumers.orElseGet(ArrayList::new));
    }

    private RetryRegistry createRetryRegistry(RetryConfigurationProperties retryConfigurationProperties, RegistryEventConsumer<Retry> retryRegistryEventConsumer, CompositeCustomizer<RetryConfigCustomizer> compositeRetryCustomizer) {
        java.util.Map<String, RetryConfig> configs = retryConfigurationProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> retryConfigurationProperties.createRetryConfig((RetryConfigurationProperties.InstanceProperties)entry.getValue(), compositeRetryCustomizer, (String)entry.getKey())));
        return RetryRegistry.of(configs, retryRegistryEventConsumer, (Map)HashMap.ofAll((java.util.Map)retryConfigurationProperties.getTags()));
    }

    private void registerEventConsumer(RetryRegistry retryRegistry, EventConsumerRegistry<RetryEvent> eventConsumerRegistry, RetryConfigurationProperties retryConfigurationProperties) {
        retryRegistry.getEventPublisher().onEntryAdded(event -> this.registerEventConsumer(eventConsumerRegistry, (Retry)event.getAddedEntry(), retryConfigurationProperties));
    }

    private void registerEventConsumer(EventConsumerRegistry<RetryEvent> eventConsumerRegistry, Retry retry, RetryConfigurationProperties retryConfigurationProperties) {
        int eventConsumerBufferSize = Optional.ofNullable(retryConfigurationProperties.getBackendProperties(retry.getName())).map(RetryConfigurationProperties.InstanceProperties::getEventConsumerBufferSize).orElse(100);
        retry.getEventPublisher().onEvent((EventConsumer)eventConsumerRegistry.createEventConsumer(retry.getName(), eventConsumerBufferSize));
    }

    @Bean
    @Conditional(value={AspectJOnClasspathCondition.class})
    public RetryAspect retryAspect(RetryConfigurationProperties retryConfigurationProperties, RetryRegistry retryRegistry, @Autowired(required=false) List<RetryAspectExt> retryAspectExtList, FallbackDecorators fallbackDecorators) {
        return new RetryAspect(retryConfigurationProperties, retryRegistry, retryAspectExtList, fallbackDecorators);
    }

    @Bean
    @Conditional(value={RxJava2OnClasspathCondition.class, AspectJOnClasspathCondition.class})
    public RxJava2RetryAspectExt rxJava2RetryAspectExt() {
        return new RxJava2RetryAspectExt();
    }

    @Bean
    @Conditional(value={ReactorOnClasspathCondition.class, AspectJOnClasspathCondition.class})
    public ReactorRetryAspectExt reactorRetryAspectExt() {
        return new ReactorRetryAspectExt();
    }

    @Bean
    public EventConsumerRegistry<RetryEvent> retryEventConsumerRegistry() {
        return new DefaultEventConsumerRegistry();
    }
}

