/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.spring6.fallback;

import io.github.resilience4j.core.lang.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class FallbackMethod {
    private static final Map<MethodMeta, Map<Class<?>, Method>> FALLBACK_METHODS_CACHE = new ConcurrentReferenceHashMap();
    private final Map<Class<?>, Method> fallbackMethods;
    private final Object[] args;
    private final Object target;
    private final Class<?> returnType;

    private FallbackMethod(Map<Class<?>, Method> fallbackMethods, Class<?> originalMethodReturnType, Object[] args, Object target) {
        this.fallbackMethods = fallbackMethods;
        this.args = args;
        this.target = target;
        this.returnType = originalMethodReturnType;
    }

    public static FallbackMethod create(String fallbackMethodName, Method originalMethod, Object[] args, Class<?> originalType, Object proxy) throws NoSuchMethodException {
        MethodMeta methodMeta = new MethodMeta(fallbackMethodName, originalMethod.getParameterTypes(), originalMethod.getReturnType(), originalType);
        Map methods = FALLBACK_METHODS_CACHE.computeIfAbsent(methodMeta, FallbackMethod::extractMethods);
        if (!methods.isEmpty()) {
            return new FallbackMethod(methods, originalMethod.getReturnType(), args, proxy);
        }
        throw new NoSuchMethodException(String.format("%s %s.%s(%s,%s)", methodMeta.returnType, methodMeta.targetClass, methodMeta.fallbackMethodName, StringUtils.arrayToDelimitedString((Object[])methodMeta.params, (String)","), Throwable.class));
    }

    private static Map<Class<?>, Method> extractMethods(MethodMeta methodMeta) {
        HashMap methods = new HashMap();
        ReflectionUtils.doWithMethods(methodMeta.targetClass, method -> FallbackMethod.merge(method, methods), method -> FallbackMethod.filter(method, methodMeta));
        return methods;
    }

    private static void merge(Method method, Map<Class<?>, Method> methods) {
        Class<?>[] fallbackParams = method.getParameterTypes();
        Class<?> exception = fallbackParams[fallbackParams.length - 1];
        Method similar = methods.get(exception);
        if (similar != null && !Arrays.equals(similar.getParameterTypes(), method.getParameterTypes())) {
            throw new IllegalStateException("You have more that one fallback method that cover the same exception type " + exception.getName());
        }
        methods.put(exception, method);
    }

    private static boolean filter(Method method, MethodMeta methodMeta) {
        if (!method.getName().equals(methodMeta.fallbackMethodName)) {
            return false;
        }
        if (!methodMeta.returnType.isAssignableFrom(method.getReturnType())) {
            return false;
        }
        if (method.getParameterCount() == 1) {
            return Throwable.class.isAssignableFrom(method.getParameterTypes()[0]);
        }
        if (method.getParameterCount() != methodMeta.params.length + 1) {
            return false;
        }
        Class<?>[] targetParams = method.getParameterTypes();
        for (int i = 0; i < methodMeta.params.length; ++i) {
            if (methodMeta.params[i] == targetParams[i]) continue;
            return false;
        }
        return Throwable.class.isAssignableFrom(targetParams[methodMeta.params.length]);
    }

    @Nullable
    public Object fallback(Throwable thrown) throws Throwable {
        if (this.fallbackMethods.size() == 1) {
            Map.Entry<Class<?>, Method> entry = this.fallbackMethods.entrySet().iterator().next();
            if (entry.getKey().isAssignableFrom(thrown.getClass())) {
                return this.invoke(entry.getValue(), thrown);
            }
            throw thrown;
        }
        Method fallback = null;
        for (Class<?> thrownClass = thrown.getClass(); fallback == null && thrownClass != Object.class; thrownClass = thrownClass.getSuperclass()) {
            fallback = this.fallbackMethods.get(thrownClass);
        }
        if (fallback != null) {
            return this.invoke(fallback, thrown);
        }
        throw thrown;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    private Object invoke(Method fallback, Throwable throwable) throws Throwable {
        boolean accessible = fallback.isAccessible();
        try {
            if (!accessible) {
                ReflectionUtils.makeAccessible((Method)fallback);
            }
            if (this.args.length != 0) {
                if (fallback.getParameterTypes().length == 1 && Throwable.class.isAssignableFrom(fallback.getParameterTypes()[0])) {
                    Object object = fallback.invoke(this.target, throwable);
                    return object;
                }
                Object[] newArgs = Arrays.copyOf(this.args, this.args.length + 1);
                newArgs[this.args.length] = throwable;
                Object object = fallback.invoke(this.target, newArgs);
                return object;
            }
            Object newArgs = fallback.invoke(this.target, throwable);
            return newArgs;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            if (!accessible) {
                fallback.setAccessible(false);
            }
        }
    }

    private static class MethodMeta {
        final String fallbackMethodName;
        final Class<?>[] params;
        final Class<?> returnType;
        final Class<?> targetClass;

        MethodMeta(String fallbackMethodName, Class<?>[] params, Class<?> returnType, Class<?> targetClass) {
            this.fallbackMethodName = fallbackMethodName;
            this.params = params;
            this.returnType = returnType;
            this.targetClass = targetClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodMeta that = (MethodMeta)o;
            return this.targetClass.equals(that.targetClass) && this.fallbackMethodName.equals(that.fallbackMethodName) && this.returnType.equals(that.returnType) && Arrays.equals(this.params, that.params);
        }

        public int hashCode() {
            return this.targetClass.getName().hashCode() ^ this.fallbackMethodName.hashCode();
        }
    }
}

