/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.spring6.retry.configure;

import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.retry.configuration.CommonRetryConfigurationProperties;
import io.github.resilience4j.common.retry.configuration.RetryConfigCustomizer;
import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.ContextAwareScheduledThreadPoolExecutor;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.registry.CompositeRegistryEventConsumer;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.spring6.fallback.FallbackExecutor;
import io.github.resilience4j.spring6.fallback.configure.FallbackConfiguration;
import io.github.resilience4j.spring6.retry.configure.ReactorRetryAspectExt;
import io.github.resilience4j.spring6.retry.configure.RetryAspect;
import io.github.resilience4j.spring6.retry.configure.RetryAspectExt;
import io.github.resilience4j.spring6.retry.configure.RetryConfigurationProperties;
import io.github.resilience4j.spring6.retry.configure.RxJava2RetryAspectExt;
import io.github.resilience4j.spring6.spelresolver.SpelResolver;
import io.github.resilience4j.spring6.spelresolver.configure.SpelResolverConfiguration;
import io.github.resilience4j.spring6.utils.AspectJOnClasspathCondition;
import io.github.resilience4j.spring6.utils.ReactorOnClasspathCondition;
import io.github.resilience4j.spring6.utils.RxJava2OnClasspathCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration
@Import(value={FallbackConfiguration.class, SpelResolverConfiguration.class})
public class RetryConfiguration {
    @Bean
    @Qualifier(value="compositeRetryCustomizer")
    public CompositeCustomizer<RetryConfigCustomizer> compositeRetryCustomizer(@Autowired(required=false) List<RetryConfigCustomizer> configCustomizers) {
        return new CompositeCustomizer(configCustomizers);
    }

    @Bean
    public RetryRegistry retryRegistry(RetryConfigurationProperties retryConfigurationProperties, EventConsumerRegistry<RetryEvent> retryEventConsumerRegistry, RegistryEventConsumer<Retry> retryRegistryEventConsumer, @Qualifier(value="compositeRetryCustomizer") CompositeCustomizer<RetryConfigCustomizer> compositeRetryCustomizer) {
        RetryRegistry retryRegistry = this.createRetryRegistry(retryConfigurationProperties, retryRegistryEventConsumer, compositeRetryCustomizer);
        this.registerEventConsumer(retryRegistry, retryEventConsumerRegistry, retryConfigurationProperties);
        retryConfigurationProperties.getInstances().forEach((name, properties) -> retryRegistry.retry(name, retryConfigurationProperties.createRetryConfig((String)name, (CompositeCustomizer)compositeRetryCustomizer)));
        return retryRegistry;
    }

    @Bean
    @Primary
    public RegistryEventConsumer<Retry> retryRegistryEventConsumer(Optional<List<RegistryEventConsumer<Retry>>> optionalRegistryEventConsumers) {
        return new CompositeRegistryEventConsumer(optionalRegistryEventConsumers.orElseGet(ArrayList::new));
    }

    private RetryRegistry createRetryRegistry(RetryConfigurationProperties retryConfigurationProperties, RegistryEventConsumer<Retry> retryRegistryEventConsumer, CompositeCustomizer<RetryConfigCustomizer> compositeRetryCustomizer) {
        Map<String, RetryConfig> configs = retryConfigurationProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> retryConfigurationProperties.createRetryConfig((CommonRetryConfigurationProperties.InstanceProperties)entry.getValue(), compositeRetryCustomizer, (String)entry.getKey())));
        return RetryRegistry.of(configs, retryRegistryEventConsumer, Map.copyOf(retryConfigurationProperties.getTags()));
    }

    private void registerEventConsumer(RetryRegistry retryRegistry, EventConsumerRegistry<RetryEvent> eventConsumerRegistry, RetryConfigurationProperties properties) {
        retryRegistry.getEventPublisher().onEntryAdded(event -> this.registerEventConsumer(eventConsumerRegistry, (Retry)event.getAddedEntry(), properties)).onEntryReplaced(event -> this.registerEventConsumer(eventConsumerRegistry, (Retry)event.getNewEntry(), properties));
    }

    private void registerEventConsumer(EventConsumerRegistry<RetryEvent> eventConsumerRegistry, Retry retry, RetryConfigurationProperties retryConfigurationProperties) {
        int eventConsumerBufferSize = Optional.ofNullable(retryConfigurationProperties.getBackendProperties(retry.getName())).map(CommonRetryConfigurationProperties.InstanceProperties::getEventConsumerBufferSize).orElse(100);
        retry.getEventPublisher().onEvent((EventConsumer)eventConsumerRegistry.createEventConsumer(retry.getName(), eventConsumerBufferSize));
    }

    @Bean
    @Conditional(value={AspectJOnClasspathCondition.class})
    public RetryAspect retryAspect(RetryConfigurationProperties retryConfigurationProperties, RetryRegistry retryRegistry, @Autowired(required=false) List<RetryAspectExt> retryAspectExtList, FallbackExecutor fallbackExecutor, SpelResolver spelResolver, @Autowired(required=false) ContextAwareScheduledThreadPoolExecutor contextAwareScheduledThreadPoolExecutor) {
        return new RetryAspect(retryConfigurationProperties, retryRegistry, retryAspectExtList, fallbackExecutor, spelResolver, contextAwareScheduledThreadPoolExecutor);
    }

    @Bean
    @Conditional(value={RxJava2OnClasspathCondition.class, AspectJOnClasspathCondition.class})
    public RxJava2RetryAspectExt rxJava2RetryAspectExt() {
        return new RxJava2RetryAspectExt();
    }

    @Bean
    @Conditional(value={ReactorOnClasspathCondition.class, AspectJOnClasspathCondition.class})
    public ReactorRetryAspectExt reactorRetryAspectExt() {
        return new ReactorRetryAspectExt();
    }

    @Bean
    public EventConsumerRegistry<RetryEvent> retryEventConsumerRegistry() {
        return new DefaultEventConsumerRegistry();
    }
}

