/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.spring6.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.context.annotation.ConditionContext;

public class AspectUtil {
    private AspectUtil() {
    }

    static boolean checkClassIfFound(ConditionContext context, String classToCheck, Consumer<Exception> exceptionConsumer) {
        try {
            Class<?> aClass = Objects.requireNonNull(context.getClassLoader(), "context must not be null").loadClass(classToCheck);
            return aClass != null;
        }
        catch (ClassNotFoundException e) {
            exceptionConsumer.accept(e);
            return false;
        }
    }

    @SafeVarargs
    public static <T> Set<T> newHashSet(T ... objs) {
        HashSet set = new HashSet();
        Collections.addAll(set, objs);
        return Collections.unmodifiableSet(set);
    }
}

