/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.vavr.CheckedConsumer;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import io.vavr.control.Either;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.function.Supplier;

public interface VavrBulkhead {
    public static <T> CheckedFunction0<T> decorateCheckedSupplier(Bulkhead bulkhead, CheckedFunction0<T> supplier) {
        return (CheckedFunction0 & Serializable)() -> {
            bulkhead.acquirePermission();
            try {
                Object object = supplier.apply();
                return object;
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(Bulkhead bulkhead, CheckedRunnable runnable) {
        return () -> {
            bulkhead.acquirePermission();
            try {
                runnable.run();
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static <T> Supplier<Try<T>> decorateTrySupplier(Bulkhead bulkhead, Supplier<Try<T>> supplier) {
        return () -> {
            if (bulkhead.tryAcquirePermission()) {
                try {
                    Try try_ = (Try)supplier.get();
                    return try_;
                }
                finally {
                    bulkhead.onComplete();
                }
            }
            return Try.failure((Throwable)BulkheadFullException.createBulkheadFullException((Bulkhead)bulkhead));
        };
    }

    public static <T> Supplier<Either<Exception, T>> decorateEitherSupplier(Bulkhead bulkhead, Supplier<Either<? extends Exception, T>> supplier) {
        return () -> {
            if (bulkhead.tryAcquirePermission()) {
                try {
                    Either result = (Either)supplier.get();
                    Either either = Either.narrow((Either)result);
                    return either;
                }
                finally {
                    bulkhead.onComplete();
                }
            }
            return Either.left((Object)BulkheadFullException.createBulkheadFullException((Bulkhead)bulkhead));
        };
    }

    public static <T> CheckedConsumer<T> decorateCheckedConsumer(Bulkhead bulkhead, CheckedConsumer<T> consumer) {
        return t -> {
            bulkhead.acquirePermission();
            try {
                consumer.accept(t);
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(Bulkhead bulkhead, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> {
            bulkhead.acquirePermission();
            try {
                Object object = function.apply(t);
                return object;
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static <T> Try<T> executeTrySupplier(Bulkhead bulkhead, Supplier<Try<T>> supplier) {
        return VavrBulkhead.decorateTrySupplier(bulkhead, supplier).get();
    }

    public static <T> Either<Exception, T> executeEitherSupplier(Bulkhead bulkhead, Supplier<Either<? extends Exception, T>> supplier) {
        return VavrBulkhead.decorateEitherSupplier(bulkhead, supplier).get();
    }

    public static <T> T executeCheckedSupplier(Bulkhead bulkhead, CheckedFunction0<T> checkedSupplier) throws Throwable {
        return (T)VavrBulkhead.decorateCheckedSupplier(bulkhead, checkedSupplier).apply();
    }
}

