/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.plugins;

import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.JadxPluginInfo;
import jadx.api.plugins.input.JadxInputPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxPluginManager {
    private static final Logger LOG = LoggerFactory.getLogger(JadxPluginManager.class);
    private final Set<PluginData> allPlugins = new TreeSet<PluginData>();
    private final Map<String, String> provideSuggestions = new TreeMap<String, String>();
    private List<JadxPlugin> resolvedPlugins = Collections.emptyList();

    public void providesSuggestion(String provides, String pluginId) {
        this.provideSuggestions.put(provides, pluginId);
    }

    public void load() {
        ServiceLoader<JadxPlugin> jadxPlugins = ServiceLoader.load(JadxPlugin.class);
        for (JadxPlugin plugin : jadxPlugins) {
            this.addPlugin(plugin);
        }
        this.resolve();
    }

    public void register(JadxPlugin plugin) {
        Objects.requireNonNull(plugin);
        PluginData addedPlugin = this.addPlugin(plugin);
        LOG.debug("Register plugin: {}", (Object)addedPlugin.getPluginId());
        this.resolve();
    }

    private PluginData addPlugin(JadxPlugin plugin) {
        PluginData pluginData = new PluginData(plugin, plugin.getPluginInfo());
        if (!this.allPlugins.add(pluginData)) {
            throw new IllegalArgumentException("Duplicate plugin id: " + pluginData + ", class " + plugin.getClass());
        }
        return pluginData;
    }

    public boolean unload(String pluginId) {
        boolean result = this.allPlugins.removeIf(pd -> {
            String id = pd.getPluginId();
            boolean match = id.equals(pluginId);
            if (match) {
                LOG.debug("Unload plugin: {}", (Object)id);
            }
            return match;
        });
        this.resolve();
        return result;
    }

    public List<JadxPlugin> getAllPlugins() {
        return this.allPlugins.stream().map(PluginData::getPlugin).collect(Collectors.toList());
    }

    public List<JadxPlugin> getResolvedPlugins() {
        return Collections.unmodifiableList(this.resolvedPlugins);
    }

    public List<JadxInputPlugin> getInputPlugins() {
        return this.resolvedPlugins.stream().filter(JadxInputPlugin.class::isInstance).map(JadxInputPlugin.class::cast).collect(Collectors.toList());
    }

    private synchronized void resolve() {
        Map<String, List<PluginData>> provides = this.allPlugins.stream().collect(Collectors.groupingBy(p -> p.getInfo().getProvides()));
        ArrayList result = new ArrayList(provides.size());
        provides.forEach((provide, list) -> {
            if (list.size() == 1) {
                result.add(list.get(0));
            } else {
                String suggestion = this.provideSuggestions.get(provide);
                if (suggestion != null) {
                    list.stream().filter(p -> p.getPluginId().equals(suggestion)).findFirst().ifPresent(result::add);
                } else {
                    PluginData selected = (PluginData)list.get(0);
                    result.add(selected);
                    LOG.debug("Select providing '{}' plugin '{}', candidates: {}", new Object[]{provide, selected, list});
                }
            }
        });
        Collections.sort(result);
        this.resolvedPlugins = result.stream().map(PluginData::getPlugin).collect(Collectors.toList());
    }

    private static final class PluginData
    implements Comparable<PluginData> {
        private final JadxPlugin plugin;
        private final JadxPluginInfo info;

        private PluginData(JadxPlugin plugin, JadxPluginInfo info) {
            this.plugin = plugin;
            this.info = info;
        }

        public JadxPlugin getPlugin() {
            return this.plugin;
        }

        public JadxPluginInfo getInfo() {
            return this.info;
        }

        public String getPluginId() {
            return this.info.getPluginId();
        }

        @Override
        public int compareTo(@NotNull PluginData o) {
            return this.info.getPluginId().compareTo(o.info.getPluginId());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PluginData)) {
                return false;
            }
            PluginData that = (PluginData)o;
            return this.getInfo().getPluginId().equals(that.getInfo().getPluginId());
        }

        public int hashCode() {
            return this.info.getPluginId().hashCode();
        }

        public String toString() {
            return this.info.getPluginId();
        }
    }
}

