/*
 * Decompiled with CFR 0.152.
 */
package io.github.yamlpath;

import io.github.yamlpath.setters.LastNodeSetter;
import io.github.yamlpath.setters.Setter;
import io.github.yamlpath.utils.PathUtils;
import io.github.yamlpath.utils.StringUtils;
import java.util.Map;

public class WorkUnit {
    private String expression;
    private Map<Object, Object> node;
    private Path lastVisited;
    private Object result;
    private Setter setter = new LastNodeSetter(this);

    public WorkUnit(Map<Object, Object> node, String expression) {
        this.node = node;
        this.expression = expression;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public boolean hasNextPath() {
        return !StringUtils.isNullOrEmpty(this.expression);
    }

    public Path getLastVisited() {
        return this.lastVisited;
    }

    public void setSetter(Setter setter) {
        if (!this.hasNextPath()) {
            this.setter = setter;
        }
    }

    public Path nextPath() {
        String part;
        while (this.expression.indexOf(".") == 0) {
            this.expression = this.expression.substring(1);
        }
        int nextIndex = -1;
        if (this.expression.startsWith("'")) {
            String nextPart = this.expression.substring(1);
            nextIndex = nextPart.indexOf("'") + 1;
            part = nextPart.substring(0, nextIndex - 1);
        } else if (this.expression.startsWith("(")) {
            String nextPart = this.expression.substring(1);
            nextIndex = nextPart.indexOf(")") + 1;
            part = nextPart.substring(0, nextIndex - 1);
        } else {
            nextIndex = this.expression.indexOf(".");
            part = PathUtils.normalize(nextIndex > 0 ? this.expression.substring(0, nextIndex) : this.expression);
        }
        this.expression = nextIndex > 0 ? this.expression.substring(nextIndex + 1) : "";
        this.lastVisited = new Path(part, this.node);
        return this.lastVisited;
    }

    public WorkUnit clone() {
        WorkUnit workUnit = new WorkUnit(this.node, this.expression);
        workUnit.lastVisited = this.lastVisited;
        workUnit.result = this.result;
        return workUnit;
    }

    protected void setNode(Map<Object, Object> node) {
        this.node = node;
    }

    protected void replaceResourceWith(Object replacement) {
        if (!"no".equals(replacement)) {
            this.setter.setValue(replacement);
        }
    }

    public static class Path {
        private final String part;
        private final Map<Object, Object> tree;

        public Path(String part, Map<Object, Object> tree) {
            this.part = part;
            this.tree = tree;
        }

        public String getPart() {
            return this.part;
        }

        public Map<Object, Object> getTree() {
            return this.tree;
        }
    }
}

