/*
 * Decompiled with CFR 0.152.
 */
package io.github.yamlpath;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.github.yamlpath.WorkUnit;
import io.github.yamlpath.processor.PathProcessor;
import io.github.yamlpath.utils.SerializationUtils;
import io.github.yamlpath.utils.SetUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class YamlExpressionParser {
    private final List<Map<Object, Object>> resources;
    private final List<PathProcessor> processors;

    public YamlExpressionParser(List<Map<Object, Object>> resources) {
        this.resources = resources;
        this.processors = StreamSupport.stream(ServiceLoader.load(PathProcessor.class, YamlExpressionParser.class.getClassLoader()).spliterator(), false).collect(Collectors.toList());
    }

    public List<Map<Object, Object>> getResources() {
        return Collections.unmodifiableList(this.resources);
    }

    public String dumpAsString() {
        try {
            if (this.resources.size() == 1) {
                return SerializationUtils.yamlMapper().writeValueAsString(this.resources.get(0));
            }
            return SerializationUtils.yamlMapper().writeValueAsString(this.resources);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T readSingle(String path) {
        return this.readSingleAndReplace(path, "no");
    }

    public <T> Set<T> read(String path) {
        return this.readAndReplace(path, "no");
    }

    public Map<String, Object> read(List<String> paths) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String path : paths) {
            Set found = this.read(path);
            if (found.size() == 1) {
                result.put(path, found.iterator().next());
                continue;
            }
            result.put(path, found);
        }
        return result;
    }

    public YamlExpressionParser write(List<String> paths, Object replacement) {
        for (String path : paths) {
            this.readAndReplace(path, replacement);
        }
        return this;
    }

    public YamlExpressionParser write(String path, Object replacement) {
        this.readAndReplace(path, replacement);
        return this;
    }

    public <T> T readSingleAndReplace(String path, Object replacement) {
        Set<T> values = this.readAndReplace(path, replacement);
        return SetUtils.uniqueResult(values);
    }

    public <T> Set<T> readAndReplace(String path, Object replacement) {
        LinkedHashSet<Object> values = new LinkedHashSet<Object>();
        for (Map<Object, Object> resource : this.resources) {
            Object value = this.doReadAndReplace(new WorkUnit(resource, path), replacement);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    private Object doReadAndReplace(WorkUnit workUnit, Object replacement) {
        if (!workUnit.hasNextPath()) {
            workUnit.replaceResourceWith(replacement);
            return workUnit.getResult();
        }
        WorkUnit.Path nextPath = workUnit.nextPath();
        for (PathProcessor processor : this.processors) {
            if (!processor.canHandle(nextPath)) continue;
            workUnit.setResult(processor.handle(workUnit, nextPath));
            return this.processResult(workUnit, replacement);
        }
        return null;
    }

    private Object processResult(WorkUnit workUnit, Object replacement) {
        if (workUnit.getResult() != null) {
            if (workUnit.hasNextPath()) {
                if (workUnit.getResult() instanceof Map) {
                    workUnit.setNode((Map)workUnit.getResult());
                    return this.doReadAndReplace(workUnit, replacement);
                }
                if (workUnit.getResult() instanceof List) {
                    LinkedList<Object> values = new LinkedList<Object>();
                    for (Object inner : (List)workUnit.getResult()) {
                        if (!(inner instanceof Map)) continue;
                        workUnit.setNode((Map)inner);
                        Object value = this.doReadAndReplace(workUnit.clone(), replacement);
                        if (value == null) continue;
                        if (value instanceof List) {
                            values.addAll((List)value);
                            continue;
                        }
                        values.add(value);
                    }
                    if (values.isEmpty()) {
                        return null;
                    }
                    if (values.size() == 1) {
                        return values.get(0);
                    }
                    return values;
                }
            } else {
                workUnit.replaceResourceWith(replacement);
            }
        }
        return workUnit.getResult();
    }
}

